/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.verzik.commons;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.tobqol.api.game.Instance;
import java.awt.Color;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public enum VerzikMap {
    VERZIK_P1_INACTIVE(10830, 8369, 10847),
    VERZIK_P1(10831, 8370, 10848),
    VERZIK_P2_INACTIVE(10832, 8371, 10849),
    VERZIK_P2(10833, 8372, 10850),
    VERZIK_P3_INACTIVE(10834, 8373, 10851),
    VERZIK_P3(10835, 8374, 10852),
    VERZIK_BAT(10836, 8375, 10853),
    PURPLE_NYLO(10844, 8384, 10861),
    RED_NYLO(10845, 8385, 10862),
    MELEE_NYLO(10841, 8381, 10858),
    RANGE_NYLO(10842, 8382, 10859),
    MAGIC_NYLO(10843, 8383, 10860),
    WEB(10837, 8376, 10854),
    TORNADO(10846, 8386, 10863);

    private final int sm;
    private final int rg;
    private final int hm;
    public static final String BOSS_NAME = "Verzik Vitur";
    public static final Pattern VERZIK_WAVE;
    public static final int BOSS_IMAGE = 22473;
    public static final int PILLAR_NPC_ID = 8379;
    public static final int COLLAPSING_PILLAR_NPC_ID = 8377;
    public static final int VERZIK_P1_ATK_ANIM = 8109;
    public static final int VERZIK_P2_ATK_ANIM = 8114;
    public static final int VERZIK_P2_BOUNCE_ANIM = 8116;
    public static final int VERZIK_P2_HEALING_STATE_ANIM = 8117;
    public static final int VERZIK_P2_TRANSITION = 8118;
    public static final int VERZIK_P3_MAGIC_ANIM = 8124;
    public static final int VERZIK_P3_RANGE_ANIM = 8125;
    public static final int VERZIK_P3_YELLOWS_ANIM = 8126;
    public static final int VERZIK_P3_WEBS_ANIM = 8127;
    public static final int YELLOW_POOL = 1595;
    public static final int YELLOW_GRAPHIC = 1597;
    public static final int GREEN_BALL = 1598;
    public static final String GREEN_BALL_TEXT = "Verzik Vitur fires a powerful projectile in your direction...";
    public static final String GREEN_BALL_BOUNCE_TEXT = "A powerful projectile bounces into your direction...";
    public static final Color VERZIK_COLOR;
    private static final ImmutableMultimap<VerzikMap, Integer> container;
    private static final Table<Instance.Mode, Integer, VerzikMap> lookupTable;

    public static boolean matchesAnyMode(VerzikMap def, int npcId) {
        if (def == null) {
            return false;
        }
        return container.get((Object)def).contains((Object)npcId);
    }

    @Nullable
    public static VerzikMap queryTable(Instance.Mode mode, int npcId) {
        if (mode == null) {
            return null;
        }
        return (VerzikMap)((Object)lookupTable.get((Object)mode, (Object)npcId));
    }

    @Nullable
    public static VerzikMap queryTable(int npcId) {
        for (Instance.Mode mode : Instance.Mode.values()) {
            VerzikMap def = VerzikMap.queryTable(mode, npcId);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    public static boolean isStoryMode(int npcId) {
        return VerzikMap.queryTable(Instance.Mode.STORY, npcId) != null;
    }

    public static boolean isRegularMode(int npcId) {
        return VerzikMap.queryTable(Instance.Mode.REGULAR, npcId) != null;
    }

    public static boolean isHardMode(int npcId) {
        return VerzikMap.queryTable(Instance.Mode.HARD, npcId) != null;
    }

    @Nullable
    public static Instance.Mode findMode(int npcId) {
        if (VerzikMap.isStoryMode(npcId)) {
            return Instance.Mode.STORY;
        }
        if (VerzikMap.isRegularMode(npcId)) {
            return Instance.Mode.REGULAR;
        }
        if (VerzikMap.isHardMode(npcId)) {
            return Instance.Mode.HARD;
        }
        return null;
    }

    private VerzikMap(int sm, int rg, int hm) {
        this.sm = sm;
        this.rg = rg;
        this.hm = hm;
    }

    public int sm() {
        return this.sm;
    }

    public int rg() {
        return this.rg;
    }

    public int hm() {
        return this.hm;
    }

    static {
        VERZIK_WAVE = Pattern.compile("Wave 'The Final Challenge' \\(.*\\) complete!");
        VERZIK_COLOR = new Color(176, 92, 204);
        ImmutableListMultimap.Builder mapBuilder = new ImmutableListMultimap.Builder();
        ImmutableTable.Builder tableBuilder = new ImmutableTable.Builder();
        for (VerzikMap def : VerzikMap.values()) {
            mapBuilder.putAll((Object)def, (Object[])new Integer[]{def.sm, def.rg, def.hm});
            tableBuilder.put(Tables.immutableCell((Object)((Object)Instance.Mode.STORY), (Object)def.sm, (Object)((Object)def)));
            tableBuilder.put(Tables.immutableCell((Object)((Object)Instance.Mode.REGULAR), (Object)def.rg, (Object)((Object)def)));
            tableBuilder.put(Tables.immutableCell((Object)((Object)Instance.Mode.HARD), (Object)def.hm, (Object)((Object)def)));
        }
        container = mapBuilder.build();
        lookupTable = tableBuilder.build();
    }
}

