/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.verzik.commons;

import com.tobqol.api.util.PerspectiveUtil;
import java.awt.Polygon;
import java.util.Optional;
import java.util.function.Predicate;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

public class Tornado
implements Predicate<NPC> {
    private final NPC npc;
    private WorldPoint first;
    private WorldPoint second;

    public Tornado(NPC npc) {
        this.npc = npc;
        this.second = this.first = npc.getWorldLocation();
    }

    public Optional<Polygon> first(Client client) {
        return PerspectiveUtil.toTilePoly(client, this.first);
    }

    public Optional<Polygon> second(Client client) {
        return PerspectiveUtil.toTilePoly(client, this.second);
    }

    public void shift() {
        this.first = this.second;
        this.second = this.npc.getWorldLocation();
    }

    @Override
    public boolean test(NPC npc) {
        return this.npc.getIndex() == npc.getIndex();
    }

    public NPC npc() {
        return this.npc;
    }
}

