/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.verzik;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.RoomSceneOverlay;
import com.tobqol.rooms.verzik.VerzikHandler;
import com.tobqol.rooms.verzik.commons.VerzikMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerzikOverlay
extends RoomSceneOverlay<VerzikHandler> {
    private static final Logger log = LoggerFactory.getLogger(VerzikOverlay.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#0.0");

    @Inject
    protected VerzikOverlay(Client client, Instance instance, VerzikHandler room, TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(client, instance, room, plugin, config);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.instance.getCurrentRegion().isVerzik()) {
            return null;
        }
        NPC verzikNpc = ((VerzikHandler)this.room).getVerzikNpc();
        if (verzikNpc == null) {
            return null;
        }
        VerzikMap def = VerzikMap.queryTable(verzikNpc.getId());
        if (def == null) {
            return null;
        }
        graphics.setFont(this.plugin.getPluginFont());
        switch (def) {
            case VERZIK_P2: {
                this.displayRedCrabs(graphics);
                break;
            }
            case VERZIK_P3: {
                this.displayTornadoes(graphics);
            }
        }
        return null;
    }

    private void displayTornadoes(Graphics2D graphics) {
        if (!this.config.shouldMarkVerzikTornadoes() || ((VerzikHandler)this.room).getTornadoes().isEmpty()) {
            return;
        }
        ((VerzikHandler)this.room).getTornadoes().forEach(t -> {
            Color color = this.config.verzikMarkedTornadoColor();
            t.first(this.client).ifPresent(p -> OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)p, (Color)color));
            t.second(this.client).ifPresent(p -> OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)p, (Color)color.darker()));
        });
    }

    private void displayRedCrabs(Graphics2D graphics) {
        if (this.config.verzikReds()) {
            NPC[] reds;
            ((VerzikHandler)this.room).getVerzikReds().forEach((crab, v) -> {
                int v_health = (Integer)v.getValue();
                int v_healthRation = (Integer)v.getKey();
                if (crab.getName() != null && crab.getHealthScale() > 0) {
                    v_health = crab.getHealthScale();
                    v_healthRation = Math.min(v_healthRation, crab.getHealthRatio());
                }
                String percentage = String.valueOf(DECIMAL_FORMAT.format((float)v_healthRation / (float)v_health * 100.0f));
                Point textLocation = crab.getCanvasTextLocation(graphics, percentage, 80);
                if (!crab.isDead() && textLocation != null) {
                    OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)percentage, (Color)Color.WHITE);
                }
            });
            for (NPC npc : reds = ((VerzikHandler)this.room).getVerzikReds().keySet().toArray(new NPC[0])) {
                if (npc.getName() == null || npc.getHealthScale() <= 0 || npc.getHealthRatio() >= 100) continue;
                MutablePair newVal = new MutablePair((Object)npc.getHealthRatio(), (Object)npc.getHealthScale());
                if (!((VerzikHandler)this.room).getVerzikReds().containsKey(npc)) continue;
                ((VerzikHandler)this.room).getVerzikReds().put(npc, (Pair<Integer, Integer>)newVal);
            }
        }
    }
}

