/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.verzik;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.verzik.VerzikOverlay;
import com.tobqol.rooms.verzik.commons.Tornado;
import com.tobqol.rooms.verzik.commons.VerzikMap;
import com.tobqol.tracking.RoomDataHandler;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoBox;
import com.tobqol.tracking.RoomInfoUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerzikHandler
extends RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(VerzikHandler.class);
    @Inject
    private VerzikOverlay overlay;
    private RoomDataHandler dataHandler;
    private NPC verzikNpc = null;
    private RoomInfoBox verzikInfoBox;
    private final Map<NPC, Pair<Integer, Integer>> verzikReds = new HashMap<NPC, Pair<Integer, Integer>>();
    private final ArrayList<Tornado> tornadoes = new ArrayList();
    private final List<WorldPoint> yellows = new ArrayList<WorldPoint>();
    private boolean allYellowsSpawned = false;
    private byte ticksLeft = (byte)-1;
    private static Clip soundClip;
    private boolean deathBallSpawned = false;
    private int deathBallSafetyNet = 0;

    @Inject
    protected VerzikHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(plugin, config);
        this.setRoomRegion(Region.VERZIK);
        this.dataHandler = plugin.getDataHandler();
    }

    @Override
    public void load() {
        this.overlayManager.add((Overlay)this.overlay);
        soundClip = this.generateSoundClip("weewoo-hoyaa.wav", this.config.sotetsegSoundClipVolume());
    }

    @Override
    public void unload() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.reset();
    }

    @Override
    public boolean active() {
        return this.instance.getCurrentRegion().isVerzik();
    }

    @Override
    public void reset() {
        this.verzikNpc = null;
        this.verzikReds.clear();
        this.tornadoes.clear();
        this.ticksLeft = (byte)-1;
        this.yellows.clear();
        this.deathBallSpawned = false;
        this.deathBallSafetyNet = 0;
        if (this.instance.getRaidStatus() <= 1) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.verzikInfoBox);
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("tobqol") || !this.instance.getCurrentRegion().isSotetsegUnderworld()) {
            return;
        }
        switch (e.getKey()) {
            case "verzikSoundClipVolume": {
                if (soundClip == null || !this.config.verzikSoundClip()) break;
                FloatControl control = (FloatControl)soundClip.getControl(FloatControl.Type.MASTER_GAIN);
                if (control != null) {
                    control.setValue(this.config.sotetsegSoundClipVolume() / 2 - 45);
                }
                soundClip.setFramePosition(0);
                soundClip.start();
            }
        }
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        if (!this.active()) {
            return;
        }
        NPC npc = e.getNpc();
        if (npc == null) {
            return;
        }
        int id = npc.getId();
        String name = npc.getName();
        if (VerzikMap.matchesAnyMode(VerzikMap.RED_NYLO, npc.getId())) {
            this.verzikReds.putIfAbsent(npc, (Pair<Integer, Integer>)MutablePair.of((Object)npc.getHealthRatio(), (Object)npc.getHealthScale()));
            if (!this.dataHandler.Find("Reds").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Reds", this.dataHandler.getTime(), false));
            }
        }
        if (VerzikMap.matchesAnyMode(VerzikMap.TORNADO, id)) {
            this.tornadoes.add(new Tornado(npc));
        }
        if (name == null) {
            return;
        }
        switch (name) {
            case "Verzik Vitur": {
                this.instance.lazySetMode(() -> VerzikMap.findMode(id));
                this.reset();
                this.verzikNpc = npc;
            }
        }
    }

    @Subscribe
    private void onNpcChanged(NpcChanged e) {
        if (!this.active()) {
            return;
        }
        VerzikMap def = VerzikMap.queryTable(e.getNpc().getId());
        if (def == null) {
            return;
        }
        switch (def) {
            case VERZIK_P1: {
                if (this.dataHandler.Find("Starting Tick").isPresent()) break;
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                this.dataHandler.setShouldTrack(true);
                break;
            }
            case VERZIK_P2: {
                if (this.dataHandler.Find("P1").isPresent()) break;
                this.dataHandler.getData().add(new RoomDataItem("P1", this.dataHandler.getTime(), !this.config.displayTimeSplits()));
            }
        }
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (!this.active()) {
            return;
        }
        NPC npc = e.getNpc();
        String name = npc.getName();
        this.verzikReds.remove(npc);
        if (this.tornadoes.contains(npc)) {
            this.tornadoes.remove(npc);
        }
        if (npc == null || name == null) {
            return;
        }
        switch (name) {
            case "Verzik Vitur": {
                this.reset();
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.instance.isInRaid() && this.instance.getCurrentRegion().isVerzik()) {
            if (this.instance.getRoomStatus() == 1 && !this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true, true));
                this.dataHandler.setShouldTrack(true);
                this.dataHandler.getData().add(new RoomDataItem("Room", this.dataHandler.getTime(), 99, false, "P2"));
            }
            if (this.dataHandler.isShouldTrack() && !this.dataHandler.getData().isEmpty()) {
                this.dataHandler.updateTotalTime();
            }
        }
        if (!this.active() || this.verzikNpc == null) {
            return;
        }
        VerzikMap def = VerzikMap.queryTable(this.verzikNpc.getId());
        if (def == null) {
            return;
        }
        switch (def) {
            case VERZIK_P3: {
                this.tornadoes.forEach(t -> t.shift());
                if (!this.yellows.isEmpty() && !this.allYellowsSpawned) {
                    this.ticksLeft = (byte)14;
                    if (this.instance.isHardMode()) {
                        this.ticksLeft = (byte)17;
                    }
                    this.allYellowsSpawned = true;
                }
                if (this.ticksLeft <= 0) {
                    this.yellows.clear();
                    return;
                }
                this.ticksLeft = (byte)(this.ticksLeft - 1);
                if (!this.deathBallSpawned || this.deathBallSafetyNet++ != 10) break;
                this.deathBallSafetyNet = 0;
                this.deathBallSpawned = false;
            }
        }
    }

    @Subscribe
    private void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (!this.active() || this.allYellowsSpawned) {
            return;
        }
        GraphicsObject obj = e.getGraphicsObject();
        if (obj.getId() == 1595) {
            WorldPoint wp = WorldPoint.fromLocal((Client)this.client, (LocalPoint)obj.getLocation());
            this.yellows.add(wp);
        }
    }

    @Subscribe
    private void onGraphicChanged(GraphicChanged e) {
        if (!this.active() || this.yellows.isEmpty() || !(e.getActor() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getActor();
        if (player.getGraphic() != 1597) {
            return;
        }
        WorldPoint wp = WorldPoint.fromLocal((Client)this.client, (LocalPoint)player.getLocalLocation());
        Predicate<WorldPoint> filter = _wp -> _wp.equals((Object)wp) || _wp.distanceTo2D(wp) <= 1;
        this.yellows.removeIf(filter);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor().getAnimation() == 8118 && !this.dataHandler.Find("P2").isPresent()) {
            this.dataHandler.getData().add(new RoomDataItem("P2", this.dataHandler.getTime(), !this.config.displayTimeSplits()));
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed event) {
        if (event.getSource() != null && event.getSource().getName() != null && this.verzikNpc != null && this.config.muteVerzikSounds() && (event.getSoundId() == 3991 || event.getSoundId() == 3987)) {
            event.consume();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.instance.getCurrentRegion() != Region.XARPUS && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String stripped = Text.removeTags((String)event.getMessage());
        if (VerzikMap.VERZIK_WAVE.matcher(stripped).find()) {
            this.dataHandler.setShouldTrack(false);
            this.dataHandler.Find("Room").get().setValue(this.dataHandler.getTime());
            if (this.config.displayRoomTimes().isInfobox()) {
                this.buildInfobox();
            }
            if (this.config.displayRoomTimes().isChat()) {
                this.sendChatTimes();
            }
        }
        if ((event.getMessage().contains("Verzik Vitur fires a powerful projectile in your direction...") || event.getMessage().contains("A powerful projectile bounces into your direction...")) && !this.deathBallSpawned) {
            if (this.config.verzikSoundClip()) {
                soundClip.setFramePosition(0);
                soundClip.start();
            }
            this.deathBallSpawned = true;
        }
    }

    private void buildInfobox() {
        if (!this.dataHandler.getData().isEmpty()) {
            String tooltip = !this.dataHandler.Find("Starting Tick").get().isException() ? "P1 - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("P1")) + "</br>Reds - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Reds")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Reds"), this.dataHandler.FindValue("P1")) + "</br>P2 - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("P2")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("P2"), this.dataHandler.FindValue("Reds")) + "</br>Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("P2")) : "Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*";
            this.verzikInfoBox = RoomInfoUtil.createInfoBox(this.plugin, this.config, (BufferedImage)this.itemManager.getImage(22473), "Verzik", RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")), tooltip);
            this.infoBoxManager.addInfoBox((InfoBox)this.verzikInfoBox);
        }
    }

    private void sendChatTimes() {
        if (!this.dataHandler.getData().isEmpty()) {
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "P1").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("P1")) + " - ").append(Color.RED, "Reds").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Reds")) + " - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Reds"), this.dataHandler.FindValue("P1")) + " - ").append(Color.RED, "P2").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("P2")) + " - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("P2"), this.dataHandler.FindValue("Reds"))));
                if (this.config.roomTimeValidation()) {
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Verzik - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("P2"))));
                }
            } else if (this.config.roomTimeValidation()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Verzik - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*"));
            }
        }
    }

    public NPC getVerzikNpc() {
        return this.verzikNpc;
    }

    public Map<NPC, Pair<Integer, Integer>> getVerzikReds() {
        return this.verzikReds;
    }

    public ArrayList<Tornado> getTornadoes() {
        return this.tornadoes;
    }

    public List<WorldPoint> getYellows() {
        return this.yellows;
    }

    public byte getTicksLeft() {
        return this.ticksLeft;
    }
}

