/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.sotetseg.commons;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.sotetseg.commons.SotetsegConstants;
import net.runelite.api.GroundObject;

public enum SotetsegTable implements SotetsegConstants
{
    SOTETSEG_NOT_CLICKABLE(10864, 8387, 10867),
    SOTETSEG_CLICKABLE(10865, 8388, 10868),
    TORNADO(10866, 8389, 10869);

    private final int sm;
    private final int rg;
    private final int hm;
    private static final Table<Instance.Mode, Integer, SotetsegTable> TABLE;

    public static Instance.Mode findMode(int npcId) {
        return Instance.findFirstMode(mode -> TABLE.contains((Object)mode, (Object)npcId));
    }

    public static boolean anyMatch(SotetsegTable table, int npcId) {
        return table != null && (table.sm == npcId || table.rg == npcId || table.hm == npcId);
    }

    public static boolean isActiveMazeObject(GroundObject obj) {
        return obj != null && ACTIVE_MAZE_GROUND_OBJS.contains((Object)obj.getId());
    }

    private SotetsegTable(int sm, int rg, int hm) {
        this.sm = sm;
        this.rg = rg;
        this.hm = hm;
    }

    static {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (SotetsegTable table : SotetsegTable.values()) {
            builder.put((Object)Instance.Mode.STORY, (Object)table.sm, (Object)table);
            builder.put((Object)Instance.Mode.REGULAR, (Object)table.rg, (Object)table);
            builder.put((Object)Instance.Mode.HARD, (Object)table.hm, (Object)table);
        }
        TABLE = builder.build();
    }
}

