/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.sotetseg;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.RoomSceneOverlay;
import com.tobqol.rooms.sotetseg.SotetsegHandler;
import com.tobqol.rooms.sotetseg.config.SotetsegInstanceTimerTypes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SotetsegSceneOverlay
extends RoomSceneOverlay<SotetsegHandler> {
    private static final Logger log = LoggerFactory.getLogger(SotetsegSceneOverlay.class);

    @Inject
    protected SotetsegSceneOverlay(Client client, Instance instance, SotetsegHandler room, TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(client, instance, room, plugin, config);
    }

    public Dimension render(Graphics2D graphics) {
        if (!((SotetsegHandler)this.room).active() || ((SotetsegHandler)this.room).isClickable()) {
            if (this.config.debugSotetsegChosenText()) {
                this.drawChosenOverlay(graphics);
            }
            return null;
        }
        graphics.setFont(this.plugin.getInstanceTimerFont());
        this.drawSoteInstanceTimers(graphics);
        this.drawChosenOverlay(graphics);
        return null;
    }

    private void drawSoteInstanceTimers(Graphics2D graphics) {
        SotetsegInstanceTimerTypes type = this.config.getSotetsegInstanceTimerType();
        graphics.setFont(this.plugin.getInstanceTimerFont());
        switch (this.instance.getRoomStatus()) {
            case 0: {
                if (!type.showOnlyForEntrance() && !type.showForAll()) break;
                this.drawInstanceTimer(graphics, ((SotetsegHandler)this.room).getSotetsegNpc(), (TileObject)((SotetsegHandler)this.room).getPortal());
                break;
            }
            case 1: 
            case 2: {
                if (!type.showOnlyForMaze() && !type.showForAll()) break;
                this.drawInstanceTimer(graphics, ((SotetsegHandler)this.room).getSotetsegNpc(), (TileObject)((SotetsegHandler)this.room).getPortal());
            }
        }
    }

    private void drawChosenOverlay(Graphics2D graphics) {
        if ((((SotetsegHandler)this.room).isChosen() || this.config.debugSotetsegChosenText()) && this.config.hideSotetsegWhiteScreen() && this.config.showSotetsegChosenText()) {
            String text = "You have been chosen.";
            graphics.setFont(new Font(this.config.fontType().getName(), this.config.fontStyle().getValue(), 20));
            int width = graphics.getFontMetrics().stringWidth(text);
            int drawX = this.client.getViewportWidth() / 2 - width / 2;
            int drawY = this.client.getViewportHeight() - this.client.getViewportHeight() / 2 + this.config.sotetsegChosenTextOffset() * 10;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(drawX, drawY), (String)text, (Color)Color.WHITE);
        }
    }
}

