/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.sotetseg;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.sotetseg.SotetsegSceneOverlay;
import com.tobqol.rooms.sotetseg.commons.MutableMaze;
import com.tobqol.rooms.sotetseg.commons.SotetsegConstants;
import com.tobqol.rooms.sotetseg.commons.SotetsegNotification;
import com.tobqol.rooms.sotetseg.commons.SotetsegTable;
import com.tobqol.rooms.sotetseg.config.SotetsegProjectileTheme;
import com.tobqol.tracking.RoomDataHandler;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoBox;
import com.tobqol.tracking.RoomInfoUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.Projectile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.widgets.Widget;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SotetsegHandler
extends RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(SotetsegHandler.class);
    @Inject
    private SotetsegSceneOverlay sceneOverlay;
    private RoomDataHandler dataHandler;
    @CheckForNull
    private NPC sotetsegNpc = null;
    private RoomInfoBox sotetsegInfoBox;
    private boolean clickable = false;
    @CheckForNull
    private MutableMaze maze = null;
    @CheckForNull
    private GameObject portal = null;
    private boolean considerTeleport = true;
    private static Clip soundClip;
    private boolean deathBallSpawned = false;
    private int deathBallSafetyNet = 0;
    private boolean chosen = false;
    public int chosenTextTimeout;
    @Inject
    private WSClient wsClient;
    @Inject
    private PartyService party;

    @Inject
    protected SotetsegHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(plugin, config);
        this.setRoomRegion(Region.SOTETSEG);
        this.dataHandler = plugin.getDataHandler();
    }

    @Override
    public void load() {
        this.overlayManager.add((Overlay)this.sceneOverlay);
        soundClip = this.generateSoundClip("weewoo-hoyaa.wav", this.config.sotetsegSoundClipVolume());
        this.wsClient.registerMessage(SotetsegNotification.class);
    }

    @Override
    public void unload() {
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.wsClient.unregisterMessage(SotetsegNotification.class);
        this.reset();
    }

    @Override
    public boolean active() {
        return this.instance.getCurrentRegion().isSotetseg() && this.sotetsegNpc != null && !this.sotetsegNpc.isDead();
    }

    @Override
    public void reset() {
        this.sotetsegNpc = null;
        this.clickable = false;
        this.maze = null;
        this.portal = null;
        this.considerTeleport = true;
        this.deathBallSpawned = false;
        this.deathBallSafetyNet = 0;
        this.chosen = false;
        this.chosenTextTimeout = 0;
        if (this.instance.getRaidStatus() <= 1) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.sotetsegInfoBox);
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("tobqol") || !this.instance.getCurrentRegion().isSotetsegUnderworld()) {
            return;
        }
        switch (e.getKey()) {
            case "sotetsegHideUnderworldRocks": {
                SotetsegHandler.when(this.config.sotetsegHideUnderworldRocks(), this::hideUnderworldRocks, this.sceneManager::refreshScene);
                break;
            }
            case "sotetsegSoundClipVolume": {
                if (soundClip == null || !this.config.sotetsegSoundClip()) break;
                FloatControl control = (FloatControl)soundClip.getControl(FloatControl.Type.MASTER_GAIN);
                if (control != null) {
                    control.setValue(this.config.sotetsegSoundClipVolume() / 2 - 45);
                }
                soundClip.setFramePosition(0);
                soundClip.start();
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        block9: {
            Widget[] widgetsOfSotetseg;
            block8: {
                if (this.instance.isInRaid() && this.instance.getCurrentRegion().isSotetseg()) {
                    if (this.instance.getRoomStatus() == 1 && !this.dataHandler.Find("Starting Tick").isPresent()) {
                        this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true, true));
                        this.dataHandler.setShouldTrack(true);
                        this.dataHandler.getData().add(new RoomDataItem("Room", this.dataHandler.getTime(), 99, false, "33%"));
                    }
                    if (this.dataHandler.isShouldTrack() && !this.dataHandler.getData().isEmpty()) {
                        this.dataHandler.updateTotalTime();
                    }
                }
                if (!this.active()) {
                    return;
                }
                if (!this.considerTeleport) {
                    this.considerTeleport = true;
                }
                if (this.deathBallSpawned && this.deathBallSafetyNet++ == 35) {
                    this.deathBallSafetyNet = 0;
                    this.deathBallSpawned = false;
                }
                widgetsOfSotetseg = this.client.getWidget(28, 1).getChildren();
                if (this.chosen || !this.config.hideSotetsegWhiteScreen() || this.client.getWidget(28, 1) == null) break block8;
                for (Widget widget : widgetsOfSotetseg) {
                    if (widget.getText().isEmpty() || !widget.getText().contains("Sotetseg chooses you")) continue;
                    this.chosen = true;
                    widget.setText("");
                }
                break block9;
            }
            if (!this.chosen || this.chosenTextTimeout++ != 5) break block9;
            for (Widget widget : widgetsOfSotetseg) {
                if (widget.getText().isEmpty()) continue;
                this.chosen = false;
                this.chosenTextTimeout = 0;
                widget.setText("");
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (!this.active()) {
            return;
        }
        SotetsegHandler.when(this.config.sotetsegHideUnderworldRocks(), this::hideUnderworldRocks, null);
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        SotetsegHandler.isNpcFromName(e.getNpc(), "Sotetseg", n -> {
            this.instance.lazySetMode(() -> SotetsegTable.findMode(n.getId()));
            this.sotetsegNpc = n;
            this.clickable = SotetsegTable.anyMatch(SotetsegTable.SOTETSEG_CLICKABLE, n.getId());
        });
    }

    @Subscribe
    private void onNpcChanged(NpcChanged e) {
        if (!this.active()) {
            return;
        }
        SotetsegHandler.isNpcFromName(e.getNpc(), "Sotetseg", n -> {
            this.clickable = SotetsegTable.anyMatch(SotetsegTable.SOTETSEG_CLICKABLE, n.getId());
            if (this.clickable) {
                if (!this.dataHandler.Find("Starting Tick").isPresent()) {
                    this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                    this.dataHandler.setShouldTrack(true);
                }
                log.debug("[{}] - Sotetseg Changed NPC IDs -> Clickable: {}", (Object)this.client.getTickCount(), (Object)this.clickable);
            }
        });
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (!this.active() || this.client.getPlane() != 0) {
            return;
        }
        SotetsegHandler.isNpcFromName(e.getNpc(), "Sotetseg", n -> this.reset());
    }

    @Subscribe
    private void onGroundObjectSpawned(GroundObjectSpawned e) {
        if (!this.active()) {
            return;
        }
        GroundObject obj = e.getGroundObject();
        if (SotetsegTable.isActiveMazeObject(obj)) {
            if (this.maze == null) {
                this.maze = new MutableMaze(this.instance);
            }
            WorldPoint wp = WorldPoint.fromLocal((Client)this.client, (LocalPoint)e.getTile().getLocalLocation());
            this.maze.addPoint(wp.getRegionX(), wp.getRegionY());
        }
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned e) {
        if (!this.active() || this.portal != null) {
            return;
        }
        GameObject obj = e.getGameObject();
        if (obj.getId() == 33037) {
            this.portal = obj;
        }
        if (SotetsegConstants.UNDERWORLD_ROCKS.contains((Object)obj.getId())) {
            SotetsegHandler.when(this.config.sotetsegHideUnderworldRocks(), this::hideUnderworldRocks, null);
        }
    }

    @Subscribe
    private void onGameObjectDespawned(GameObjectDespawned e) {
        if (!this.active() || this.portal == null) {
            return;
        }
        if (e.getGameObject().getId() == 33037) {
            this.portal = null;
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        if (!this.instance.getCurrentRegion().isSotetseg()) {
            return;
        }
        SotetsegProjectileTheme theme = this.config.getSotetsegProjectileTheme();
        Projectile projectile = projectileMoved.getProjectile();
        int projectileId = projectile.getId();
        if (projectileId == 1604 && !this.deathBallSpawned) {
            if (this.config.sotetsegSoundClip()) {
                soundClip.setFramePosition(0);
                soundClip.start();
            }
            this.deathBallSpawned = true;
        }
        if (!theme.isDefault()) {
            int replacement = -1;
            block0 : switch (projectileId) {
                case 1607: {
                    switch (theme) {
                        case INFERNO: {
                            replacement = 1378;
                            break;
                        }
                        case TOA: {
                            replacement = 2241;
                        }
                    }
                    break;
                }
                case 1606: {
                    switch (theme) {
                        case INFERNO: {
                            replacement = 1380;
                            break;
                        }
                        case TOA: {
                            replacement = 2224;
                        }
                    }
                    break;
                }
                case 1604: {
                    if (!this.config.themedDeathBall()) break;
                    switch (theme) {
                        case INFERNO: {
                            replacement = 1375;
                            break block0;
                        }
                        case TOA: {
                            replacement = 2176;
                        }
                    }
                }
            }
            if (replacement == -1) {
                return;
            }
            Projectile p = this.client.createProjectile(replacement, projectile.getFloor(), projectile.getX1(), projectile.getY1(), projectile.getHeight(), projectile.getStartCycle(), projectile.getEndCycle(), projectile.getSlope(), projectile.getStartHeight(), projectile.getEndHeight(), projectile.getInteracting(), projectile.getTarget().getX(), projectile.getTarget().getY());
            this.client.getProjectiles().addLast((Object)p);
            projectile.setEndCycle(0);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.active() && this.considerTeleport && event.getActor().getAnimation() == 1816) {
            boolean phase = this.dataHandler.Find("66%").isPresent();
            this.dataHandler.getData().add(new RoomDataItem(phase ? "33%" : "66%", this.dataHandler.getTime(), phase ? 2 : 1, !this.config.displayTimeSplits()));
            this.considerTeleport = false;
            if (this.deathBallSpawned) {
                this.deathBallSpawned = false;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.instance.getCurrentRegion() != Region.SOTETSEG && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String stripped = Text.removeTags((String)event.getMessage());
        if (stripped.equals("A large ball of energy is shot your way...") && this.party.isInParty()) {
            this.clientThread.invokeLater(() -> this.party.send((PartyMessage)new SotetsegNotification(this.client.getLocalPlayer().getName(), true)));
        }
        if (SotetsegConstants.SOTETSEG_WAVE.matcher(stripped).find()) {
            this.dataHandler.setShouldTrack(false);
            this.dataHandler.Find("Room").get().setValue(this.dataHandler.getTime());
            if (this.config.displayRoomTimes().isInfobox()) {
                this.buildInfobox();
            }
            if (this.config.displayRoomTimes().isChat()) {
                this.sendChatTimes();
            }
        }
    }

    @Subscribe
    public void onSotetsegNotification(SotetsegNotification event) {
        if (!this.active()) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            if (!this.deathBallSpawned) {
                if (this.config.sotetsegSoundClip()) {
                    soundClip.setFramePosition(0);
                    soundClip.start();
                }
                this.deathBallSpawned = true;
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(new Color(167, 112, 225), event.getName() + " has discovered a large ball of energy shot their way..."));
            }
        });
    }

    private void buildInfobox() {
        if (!this.dataHandler.getData().isEmpty()) {
            String tooltip = !this.dataHandler.Find("Starting Tick").get().isException() ? "66% - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("66%")) + "</br>33% - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("33%")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("33%"), this.dataHandler.FindValue("66%")) + "</br>Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("33%")) : "Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*";
            this.sotetsegInfoBox = RoomInfoUtil.createInfoBox(this.plugin, this.config, (BufferedImage)this.itemManager.getImage(25751), "Sotetseg", RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")), tooltip);
            this.infoBoxManager.addInfoBox((InfoBox)this.sotetsegInfoBox);
        }
    }

    private void sendChatTimes() {
        if (!this.dataHandler.getData().isEmpty()) {
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "66%").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("66%")) + " - ").append(Color.RED, "33%").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("33%")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("33%"), this.dataHandler.FindValue("66%"))));
                if (this.config.roomTimeValidation()) {
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Sotetseg - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("33%"))));
                }
            } else if (this.config.roomTimeValidation()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Sotetseg - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*"));
            }
        }
    }

    private void hideUnderworldRocks() {
        if (this.instance.getCurrentRegion().isSotetsegUnderworld()) {
            this.sceneManager.removeTheseGameObjects(3, (Collection<Integer>)SotetsegConstants.UNDERWORLD_ROCKS);
        }
    }

    @CheckForNull
    public NPC getSotetsegNpc() {
        return this.sotetsegNpc;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @CheckForNull
    public MutableMaze getMaze() {
        return this.maze;
    }

    @CheckForNull
    public GameObject getPortal() {
        return this.portal;
    }

    public boolean isChosen() {
        return this.chosen;
    }

    public void setChosen(boolean chosen) {
        this.chosen = chosen;
    }
}

