/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.nylocas.commons;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.nylocas.commons.NylocasType;
import java.awt.Color;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.runelite.api.Point;

public enum NylocasConstants {
    BOSS_DROPPING_MELEE(10786, 8354, 10807),
    BOSS_MELEE(10787, 8355, 10808),
    BOSS_MAGIC(10788, 8356, 10809),
    BOSS_RANGE(10789, 8357, 10810),
    DEMI_BOSS_DROPPING_MELEE(10803),
    DEMI_BOSS_MELEE(10804),
    DEMI_BOSS_MAGIC(10805),
    DEMI_BOSS_RANGE(10806),
    MELEE_SMALL(10791, 8342, 10791, 10780, 8348, 10797),
    RANGE_SMALL(10775, 8343, 10792, 10781, 8349, 10798),
    MAGIC_SMALL(10776, 8344, 10793, 10782, 8350, 10799),
    MELEE_BIG(10777, 8345, 10794, 10783, 8351, 10800),
    RANGE_BIG(10778, 8346, 10795, 10784, 8352, 10801),
    MAGIC_BIG(10779, 8347, 10796, 10785, 8353, 10802),
    PILLAR(10790, 8358, 10811);

    private final int sm;
    private final int rg;
    private final int hm;
    private final int aggro_sm;
    private final int aggro_rg;
    private final int aggro_hm;
    public static int BOSS_IMAGE;
    public static int NYLOCAS_WAVES_TOTAL;
    public static Pattern NYLOCAS_WAVE;
    public static final String BOSS_NAME = "Nylocas Vasilias";
    public static final String DEMI_BOSS_NAME = "Nylocas Prinkipas";
    public static final String MELEE_NAME = "Nylocas Ischyros";
    public static final String RANGE_NAME = "Nylocas Toxobolos";
    public static final String MAGIC_NAME = "Nylocas Hagios";
    public static final int BOSS_MAGIC_ANIM = 7989;
    public static final int BOSS_RANGE_ANIM = 7999;
    public static final int BOSS_MELEE_ANIM = 8004;
    public static final int PILLAR_GO_ID = 32862;
    public static final int PILLAR_COLLAPSED_GO_ID = 32864;
    public static final int SPECTATOR_WEB_1 = 32939;
    public static final int SPECTATOR_WEB_2 = 32865;
    public static final int SPECTATOR_WEB_3 = 32937;
    public static final int WALL_1 = 32876;
    public static final int WALL_2 = 32899;
    public static final int IMMUNE_GRAPHIC = 1558;
    public static final int MELEE_SMALL_DESPAWN_GRAPHIC = 1562;
    public static final int RANGE_SMALL_DESPAWN_GRAPHIC = 1563;
    public static final int MAGIC_SMALL_DESPAWN_GRAPHIC = 1564;
    public static final int UNK_DESPAWN_GRAPHIC_1 = 1561;
    public static final int UNK_DESPAWN_GRAPHIC_2 = 1891;
    public static final int UNK_DESPAWN_GRAPHIC_3 = 1892;
    public static final int UNK_DESPAWN_GRAPHIC_4 = 1893;
    public static final int UNK_DESPAWN_GRAPHIC_5 = 1894;
    private static final ImmutableMultimap<NylocasConstants, Integer> ENUM_MULTIMAP;
    private static final Table<Instance.Mode, Integer, NylocasConstants> LOOKUP_TABLE;
    private static final ImmutableMultimap<NylocasType, Integer> TYPE_IDS;
    public static final Color MAGIC_COLOR;
    public static final Color MELEE_COLOR;
    public static final Color RANGE_COLOR;
    public static final Set<Point> NYLOCAS_VALID_SPAWNS;

    public static boolean matchesAnyMode(NylocasConstants def, int npcId) {
        if (def == null) {
            return false;
        }
        return ENUM_MULTIMAP.get((Object)def).contains((Object)npcId);
    }

    @Nullable
    public static NylocasConstants queryTable(Instance.Mode mode, int npcId) {
        if (mode == null) {
            return null;
        }
        return (NylocasConstants)((Object)LOOKUP_TABLE.get((Object)mode, (Object)npcId));
    }

    @Nullable
    public static Instance.Mode findMode(int npcId) {
        return Instance.findFirstMode(mode -> NylocasConstants.queryTable(mode, npcId) != null);
    }

    public static boolean isBoss(int npcId) {
        return TYPE_IDS.get((Object)NylocasType.BOSS).contains((Object)npcId);
    }

    public static boolean isDemiBoss(int npcId) {
        return TYPE_IDS.get((Object)NylocasType.DEMI).contains((Object)npcId);
    }

    public static boolean isBigNylo(int npcId) {
        return TYPE_IDS.get((Object)NylocasType.BIG).contains((Object)npcId);
    }

    public static boolean isSmallNylo(int npcId) {
        return TYPE_IDS.get((Object)NylocasType.SMALL).contains((Object)npcId);
    }

    public static boolean isWavesNylo(int npcId) {
        return NylocasConstants.isBigNylo(npcId) || NylocasConstants.isSmallNylo(npcId);
    }

    private NylocasConstants(int sm, int rg, int hm) {
        this(sm, rg, hm, -1, -1, -1);
    }

    private NylocasConstants(int hm) {
        this(-1, -1, hm);
    }

    private NylocasConstants(int sm, int rg, int hm, int aggro_sm, int aggro_rg, int aggro_hm) {
        this.sm = sm;
        this.rg = rg;
        this.hm = hm;
        this.aggro_sm = aggro_sm;
        this.aggro_rg = aggro_rg;
        this.aggro_hm = aggro_hm;
    }

    public int sm() {
        return this.sm;
    }

    public int rg() {
        return this.rg;
    }

    public int hm() {
        return this.hm;
    }

    public int aggro_sm() {
        return this.aggro_sm;
    }

    public int aggro_rg() {
        return this.aggro_rg;
    }

    public int aggro_hm() {
        return this.aggro_hm;
    }

    private static /* synthetic */ void lambda$static$3(ImmutableMultimap.Builder type_ids, NylocasConstants def) {
        type_ids.putAll((Object)NylocasType.SMALL, (Object[])new Integer[]{def.sm, def.rg, def.hm, def.aggro_sm, def.aggro_rg, def.aggro_hm});
    }

    private static /* synthetic */ void lambda$static$2(ImmutableMultimap.Builder type_ids, NylocasConstants def) {
        type_ids.putAll((Object)NylocasType.BIG, (Object[])new Integer[]{def.sm, def.rg, def.hm, def.aggro_sm, def.aggro_rg, def.aggro_hm});
    }

    private static /* synthetic */ void lambda$static$1(ImmutableMultimap.Builder type_ids, NylocasConstants def) {
        type_ids.putAll((Object)NylocasType.DEMI, (Object[])new Integer[]{def.hm});
    }

    private static /* synthetic */ void lambda$static$0(ImmutableMultimap.Builder type_ids, NylocasConstants def) {
        type_ids.putAll((Object)NylocasType.BOSS, (Object[])new Integer[]{def.sm, def.rg, def.hm});
    }

    static {
        BOSS_IMAGE = 25750;
        NYLOCAS_WAVES_TOTAL = 31;
        NYLOCAS_WAVE = Pattern.compile("Wave 'The Nylocas' \\(.*\\) complete!");
        MAGIC_COLOR = Color.CYAN;
        MELEE_COLOR = new Color(255, 188, 188);
        RANGE_COLOR = Color.GREEN;
        NYLOCAS_VALID_SPAWNS = ImmutableSet.of((Object)new Point(17, 24), (Object)new Point(17, 25), (Object)new Point(18, 24), (Object)new Point(18, 25), (Object)new Point(31, 9), (Object)new Point(31, 10), (Object[])new Point[]{new Point(32, 9), new Point(32, 10), new Point(46, 24), new Point(46, 25), new Point(47, 24), new Point(47, 25)});
        ImmutableListMultimap.Builder enum_builder = ImmutableListMultimap.builder();
        ImmutableTable.Builder t_builder = ImmutableTable.builder();
        for (NylocasConstants def : NylocasConstants.values()) {
            if (def.sm == -1 && def.rg == -1) {
                enum_builder.put((Object)def, (Object)def.hm);
                t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.HARD), (Object)def.hm, (Object)((Object)def)));
                continue;
            }
            enum_builder.putAll((Object)def, (Object[])new Integer[]{def.sm, def.rg, def.hm});
            t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.STORY), (Object)def.sm, (Object)((Object)def)));
            t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.REGULAR), (Object)def.rg, (Object)((Object)def)));
            t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.HARD), (Object)def.hm, (Object)((Object)def)));
            if (def.aggro_sm == -1 && def.aggro_rg == -1 && def.aggro_hm == -1) continue;
            enum_builder.putAll((Object)def, (Object[])new Integer[]{def.aggro_sm, def.aggro_rg, def.aggro_hm});
            t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.STORY), (Object)def.aggro_sm, (Object)((Object)def)));
            t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.REGULAR), (Object)def.aggro_rg, (Object)((Object)def)));
            t_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.HARD), (Object)def.aggro_hm, (Object)((Object)def)));
        }
        ENUM_MULTIMAP = enum_builder.build();
        LOOKUP_TABLE = t_builder.build();
        ImmutableListMultimap.Builder type_ids = ImmutableListMultimap.builder();
        ImmutableList melees = ImmutableList.of((Object)((Object)BOSS_DROPPING_MELEE), (Object)((Object)BOSS_MELEE), (Object)((Object)BOSS_MAGIC), (Object)((Object)BOSS_RANGE));
        melees.forEach(arg_0 -> NylocasConstants.lambda$static$0((ImmutableMultimap.Builder)type_ids, arg_0));
        ImmutableList demis = ImmutableList.of((Object)((Object)DEMI_BOSS_DROPPING_MELEE), (Object)((Object)DEMI_BOSS_MELEE), (Object)((Object)DEMI_BOSS_MAGIC), (Object)((Object)DEMI_BOSS_RANGE));
        demis.forEach(arg_0 -> NylocasConstants.lambda$static$1((ImmutableMultimap.Builder)type_ids, arg_0));
        ImmutableList bigs = ImmutableList.of((Object)((Object)MELEE_BIG), (Object)((Object)RANGE_BIG), (Object)((Object)MAGIC_BIG));
        bigs.forEach(arg_0 -> NylocasConstants.lambda$static$2((ImmutableMultimap.Builder)type_ids, arg_0));
        ImmutableList smalls = ImmutableList.of((Object)((Object)MELEE_SMALL), (Object)((Object)RANGE_SMALL), (Object)((Object)MAGIC_SMALL));
        smalls.forEach(arg_0 -> NylocasConstants.lambda$static$3((ImmutableMultimap.Builder)type_ids, arg_0));
        TYPE_IDS = type_ids.build();
    }
}

