/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.nylocas;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.RoomSceneOverlay;
import com.tobqol.rooms.nylocas.NylocasHandler;
import com.tobqol.rooms.nylocas.commons.NylocasConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NylocasSceneOverlay
extends RoomSceneOverlay<NylocasHandler> {
    private static final Logger log = LoggerFactory.getLogger(NylocasSceneOverlay.class);

    @Inject
    protected NylocasSceneOverlay(Client client, Instance instance, NylocasHandler room, TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(client, instance, room, plugin, config);
    }

    public Dimension render(Graphics2D graphics) {
        if (!((NylocasHandler)this.room).active()) {
            return null;
        }
        graphics.setFont(this.plugin.getPluginFont());
        this.drawPillarsHP(graphics);
        this.renderRoleOverlays(graphics);
        if (((NylocasHandler)this.room).isDisplayInstanceTimer()) {
            graphics.setFont(this.plugin.getInstanceTimerFont());
            this.drawInstanceTimer(graphics, null, null);
        }
        return null;
    }

    private void drawPillarsHP(Graphics2D graphics) {
        if (!this.config.showNylocasPillarHP()) {
            return;
        }
        Map<NPC, Integer> pillars = ((NylocasHandler)this.room).getPillars();
        if (pillars.isEmpty()) {
            return;
        }
        pillars.forEach((pillar, hp) -> {
            String str = hp + "%";
            double rMod = 130.0 * (double)hp.intValue() / 100.0;
            double gMod = 255.0 * (double)hp.intValue() / 100.0;
            double bMod = 125.0 * (double)hp.intValue() / 100.0;
            Point textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)pillar.getLocalLocation(), (String)str, (int)65);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)str, (Color)new Color((int)(255.0 - rMod), (int)(0.0 + gMod), (int)(0.0 + bMod)));
        });
    }

    private void renderRoleOverlays(Graphics2D graphics) {
        boolean displaySWTile = this.config.nyloWavesBigsSWTile();
        if (((NylocasHandler)this.room).isAnyRole() && !((NylocasHandler)this.room).getWavesMap().isEmpty()) {
            ((NylocasHandler)this.room).getWavesMap().forEach((npc, ticks) -> {
                if (npc.getName() != null && !npc.isDead()) {
                    Color color = null;
                    if (((NylocasHandler)this.room).isDisplayRoleMage() && npc.getName().equals("Nylocas Hagios")) {
                        color = NylocasConstants.MAGIC_COLOR;
                    } else if (((NylocasHandler)this.room).isDisplayRoleMelee() && npc.getName().equals("Nylocas Ischyros")) {
                        color = NylocasConstants.MELEE_COLOR;
                    } else if (((NylocasHandler)this.room).isDisplayRoleRange() && npc.getName().equals("Nylocas Toxobolos")) {
                        color = NylocasConstants.RANGE_COLOR;
                    }
                    if (color != null) {
                        LocalPoint localPoint = npc.getLocalLocation();
                        Polygon polygon = npc.getCanvasTilePoly();
                        if (polygon != null) {
                            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)color);
                        }
                        if (((NylocasHandler)this.room).getBigsMap().containsKey(npc) && displaySWTile) {
                            polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64));
                            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)color);
                        }
                    }
                }
            });
        }
    }
}

