/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.nylocas;

import com.google.common.collect.ImmutableList;
import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import com.tobqol.api.util.TheatreInputListener;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.nylocas.NylocasSceneOverlay;
import com.tobqol.rooms.nylocas.commons.NyloBoss;
import com.tobqol.rooms.nylocas.commons.NyloSelectionBox;
import com.tobqol.rooms.nylocas.commons.NyloSelectionManager;
import com.tobqol.rooms.nylocas.commons.NylocasConstants;
import com.tobqol.tracking.RoomDataHandler;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoBox;
import com.tobqol.tracking.RoomInfoUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.components.InfoBoxComponent;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NylocasHandler
extends RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(NylocasHandler.class);
    @Inject
    private NylocasSceneOverlay sceneOverlay;
    private RoomDataHandler dataHandler;
    @Inject
    private SkillIconManager skillIconManager;
    private NyloSelectionManager nyloSelectionManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private TheatreInputListener theatreInputListener;
    private boolean displayRoleSelector;
    private boolean displayRoleMage;
    private boolean displayRoleMelee;
    private boolean displayRoleRange;
    private boolean displayInstanceTimer;
    private RoomInfoBox nylocasInfoBox;
    private int wave = 0;
    private boolean waveSpawned = false;
    private NyloBoss boss = null;
    private NyloBoss demiBoss = null;
    private int demiCount = 0;
    private final Map<NPC, Integer> pillars = new HashMap<NPC, Integer>();
    private final Map<NPC, Integer> wavesMap = new HashMap<NPC, Integer>();
    private final Map<NPC, Integer> bigsMap = new HashMap<NPC, Integer>();
    private final Map<NPC, Integer> splitsMap = new HashMap<NPC, Integer>();

    @Inject
    protected NylocasHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(plugin, config);
        this.setRoomRegion(Region.NYLOCAS);
        this.dataHandler = plugin.getDataHandler();
    }

    @Override
    public void init() {
        this.displayRoleSelector = this.config.displayNyloRoleSelector();
        this.displayRoleMage = this.config.nyloRoleSelectedMage();
        this.displayRoleMelee = this.config.nyloRoleSelectedMelee();
        this.displayRoleRange = this.config.nyloRoleSelectedRange();
        InfoBoxComponent box = new InfoBoxComponent();
        box.setImage(this.skillIconManager.getSkillImage(Skill.ATTACK));
        NyloSelectionBox nyloMeleeOverlay = new NyloSelectionBox(box);
        nyloMeleeOverlay.setSelected(this.displayRoleMelee);
        box = new InfoBoxComponent();
        box.setImage(this.skillIconManager.getSkillImage(Skill.MAGIC));
        NyloSelectionBox nyloMageOverlay = new NyloSelectionBox(box);
        nyloMageOverlay.setSelected(this.displayRoleMage);
        box = new InfoBoxComponent();
        box.setImage(this.skillIconManager.getSkillImage(Skill.RANGED));
        NyloSelectionBox nyloRangeOverlay = new NyloSelectionBox(box);
        nyloRangeOverlay.setSelected(this.displayRoleRange);
        this.nyloSelectionManager = new NyloSelectionManager(this.config, nyloMeleeOverlay, nyloMageOverlay, nyloRangeOverlay);
        this.nyloSelectionManager.setHidden(!this.displayRoleSelector);
    }

    @Override
    public void load() {
        this.overlayManager.add((Overlay)this.sceneOverlay);
        this.startupNyloOverlay();
    }

    @Override
    public void unload() {
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.shutdownNyloOverlay();
        this.reset();
    }

    @Override
    public void reset() {
        this.boss = null;
        this.demiBoss = null;
        this.softReset();
        this.displayInstanceTimer = this.config.nyloInstanceTimer();
        if (this.instance.getRaidStatus() <= 1) {
            this.wave = 0;
            this.waveSpawned = false;
            this.demiCount = 0;
            this.infoBoxManager.removeInfoBox((InfoBox)this.nylocasInfoBox);
        }
    }

    private void softReset() {
        this.pillars.clear();
        this.wavesMap.clear();
        this.bigsMap.clear();
        this.splitsMap.clear();
    }

    @Override
    public boolean active() {
        return this.instance.getCurrentRegion().isNylocas();
    }

    private void startupNyloOverlay() {
        this.mouseManager.registerMouseListener((MouseListener)this.theatreInputListener);
        if (this.nyloSelectionManager != null) {
            this.overlayManager.add((Overlay)this.nyloSelectionManager);
            this.nyloSelectionManager.setHidden(true);
        }
    }

    private void shutdownNyloOverlay() {
        this.mouseManager.unregisterMouseListener((MouseListener)this.theatreInputListener);
        if (this.nyloSelectionManager != null) {
            this.overlayManager.remove((Overlay)this.nyloSelectionManager);
            this.nyloSelectionManager.setHidden(true);
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equalsIgnoreCase("tobqol")) {
            return;
        }
        switch (e.getKey()) {
            case "nyloHideObjects": {
                this.clientThread.invokeLater(() -> {
                    if (Region.inRegion(this.client, Region.NYLOCAS) && this.client.getGameState() == GameState.LOGGED_IN) {
                        this.sceneManager.refreshScene();
                        if (this.config.nyloHideObjects().isAnyOrAll()) {
                            this.hideRoomObjects(this.config.nyloHideObjects().toString());
                        } else {
                            this.client.setGameState(GameState.LOADING);
                        }
                    }
                });
                break;
            }
            case "displayNyloRoleSelector": {
                this.displayRoleSelector = Boolean.valueOf(e.getNewValue());
                this.nyloSelectionManager.setHidden(!this.displayRoleSelector);
                break;
            }
            case "nyloInstanceTimer": {
                this.displayInstanceTimer = Boolean.valueOf(e.getNewValue());
            }
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOGGED_IN && this.active()) {
            this.hideRoomObjects(this.config.nyloHideObjects().toString());
            this.nyloSelectionManager.setHidden(!this.displayRoleSelector);
            this.displayInstanceTimer = this.config.nyloInstanceTimer();
        }
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        if (!this.active()) {
            return;
        }
        NPC npc = e.getNpc();
        int id = npc.getId();
        if (NylocasConstants.matchesAnyMode(NylocasConstants.BOSS_DROPPING_MELEE, id)) {
            this.dataHandler.getData().add(new RoomDataItem("Boss", this.dataHandler.getTime(), 6, !this.config.displayTimeSplits(), "Cleanup"));
            return;
        }
        if (NylocasHandler.isNpcFromName(npc, "Nylocas Vasilias") && NylocasConstants.matchesAnyMode(NylocasConstants.BOSS_MELEE, id)) {
            this.instance.lazySetMode(() -> NylocasConstants.findMode(id));
            this.boss = NyloBoss.spawned(npc, this.instance.mode());
            this.softReset();
            return;
        }
        if (NylocasHandler.isNpcFromName(npc, "Nylocas Prinkipas") && NylocasConstants.matchesAnyMode(NylocasConstants.DEMI_BOSS_MELEE, id)) {
            this.instance.lazySetMode(() -> NylocasConstants.findMode(id));
            this.demiBoss = NyloBoss.spawned(npc, this.instance.mode());
            ++this.demiCount;
            this.dataHandler.getData().add(new RoomDataItem("Demi " + this.demiCount, this.dataHandler.getTime(), this.demiCount, true, (String)(this.demiCount > 1 ? "Demi " + (this.demiCount - 1) : "")));
            return;
        }
        if (NylocasConstants.matchesAnyMode(NylocasConstants.PILLAR, id)) {
            if (this.pillars.size() > 3) {
                this.pillars.clear();
            }
            this.pillars.putIfAbsent(npc, 100);
            if (!this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                this.dataHandler.setShouldTrack(true);
            }
            return;
        }
        if (NylocasHandler.isNpcFromName(npc, "Nylocas Ischyros") || NylocasHandler.isNpcFromName(npc, "Nylocas Toxobolos") || NylocasHandler.isNpcFromName(npc, "Nylocas Hagios")) {
            WorldPoint worldPoint;
            Point spawnPoint;
            this.instance.lazySetMode(() -> NylocasConstants.findMode(id));
            this.wavesMap.put(npc, 52);
            NPCComposition comp = npc.getTransformedComposition();
            if ((comp == null ? 1 : comp.getSize()) > 1) {
                this.bigsMap.put(npc, 1);
            }
            if (this.displayInstanceTimer) {
                this.displayInstanceTimer = false;
            }
            if (!this.waveSpawned && NylocasConstants.NYLOCAS_VALID_SPAWNS.contains(spawnPoint = new Point((worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)npc.getLocalLocation())).getRegionX(), worldPoint.getRegionY()))) {
                ++this.wave;
                this.waveSpawned = true;
                if (this.wave == NylocasConstants.NYLOCAS_WAVES_TOTAL) {
                    this.dataHandler.getData().add(new RoomDataItem("Waves", this.dataHandler.getTime(), 4, !this.config.displayTimeSplits(), this.dataHandler.Find("Demi 3").isPresent() ? "Demi 3" : ""));
                }
            }
        }
    }

    @Subscribe
    private void onNpcChanged(NpcChanged e) {
        if (!this.active() && this.boss == null && this.demiBoss == null) {
            return;
        }
        NPC npc = e.getNpc();
        if (npc != null) {
            NylocasHandler.isNpcFromName(npc, "Nylocas Vasilias", n -> this.boss.changed());
            NylocasHandler.isNpcFromName(npc, "Nylocas Prinkipas", n -> this.demiBoss.changed());
        }
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (!this.active()) {
            return;
        }
        NPC npc = e.getNpc();
        int id = npc.getId();
        if (NylocasHandler.isNpcFromName(npc, "Nylocas Vasilias") && !NylocasConstants.matchesAnyMode(NylocasConstants.BOSS_DROPPING_MELEE, id)) {
            this.reset();
            return;
        }
        if (NylocasHandler.isNpcFromName(npc, "Nylocas Prinkipas") && !NylocasConstants.matchesAnyMode(NylocasConstants.DEMI_BOSS_DROPPING_MELEE, id)) {
            this.demiBoss = null;
            return;
        }
        this.pillars.remove(npc);
        this.wavesMap.remove(npc);
        if (this.wavesMap.isEmpty() && this.wave == NylocasConstants.NYLOCAS_WAVES_TOTAL && !this.dataHandler.Find("Cleanup").isPresent()) {
            this.dataHandler.getData().add(new RoomDataItem("Cleanup", this.dataHandler.getTime(), 5, false, "Waves"));
        }
    }

    @Subscribe
    private void onMenuEntryAdded(MenuEntryAdded e) {
        if (!this.active() || !this.config.nyloWavesRecolorMenu() || this.wavesMap.isEmpty()) {
            return;
        }
        if (e.getOption().equals("Attack") || e.getType() == MenuAction.WIDGET_TARGET_ON_NPC.getId()) {
            NPC npc = this.client.getCachedNPCs()[e.getIdentifier()];
            if (npc == null) {
                return;
            }
            String target = e.getTarget();
            MenuEntry[] entries = this.client.getMenuEntries();
            MenuEntry head = entries[entries.length - 1];
            boolean darker = this.config.nyloWavesRecolorBigsMenuDarker() && npc.getTransformedComposition() != null && npc.getTransformedComposition().getSize() > 1;
            int id = npc.getId();
            target = Text.removeTags((String)target);
            Color color = null;
            if (target.contains("Nylocas Ischyros") || id == NylocasConstants.DEMI_BOSS_MELEE.hm()) {
                color = darker ? NylocasConstants.MELEE_COLOR.darker() : NylocasConstants.MELEE_COLOR;
            } else if (target.contains("Nylocas Toxobolos") || id == NylocasConstants.DEMI_BOSS_RANGE.hm()) {
                color = darker ? NylocasConstants.RANGE_COLOR.darker() : NylocasConstants.RANGE_COLOR;
            } else if (target.contains("Nylocas Hagios") || id == NylocasConstants.DEMI_BOSS_MAGIC.hm()) {
                Color color2 = color = darker ? NylocasConstants.MAGIC_COLOR.darker() : NylocasConstants.MAGIC_COLOR;
            }
            if (color != null) {
                target = ColorUtil.prependColorTag((String)target, (Color)color);
            }
            head.setTarget(target);
            this.client.setMenuEntries(entries);
        }
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.instance.isInRaid() && this.instance.getCurrentRegion().isNylocas()) {
            if (this.instance.getRoomStatus() == 1 && !this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true, true));
                this.dataHandler.setShouldTrack(true);
                this.dataHandler.getData().add(new RoomDataItem("Room", this.dataHandler.getTime(), 99, false, "Boss"));
            }
            if (this.dataHandler.isShouldTrack() && !this.dataHandler.getData().isEmpty()) {
                this.dataHandler.updateTotalTime();
            }
        }
        if (!this.active()) {
            if (!this.nyloSelectionManager.isHidden()) {
                this.nyloSelectionManager.setHidden(true);
            }
            return;
        }
        if (!this.pillars.isEmpty()) {
            for (NPC pillar : this.pillars.keySet()) {
                int ratio = pillar.getHealthRatio();
                if (ratio <= -1) continue;
                this.pillars.replace(pillar, ratio);
            }
        }
        if (!this.wavesMap.isEmpty()) {
            this.wavesMap.values().removeIf(VALUE_IS_ZERO);
            this.wavesMap.replaceAll(DECREMENT_VALUE);
            this.waveSpawned = false;
        }
        if (!this.bigsMap.isEmpty()) {
            this.bigsMap.entrySet().removeIf(entry -> {
                NPC big = (NPC)entry.getKey();
                if (big.getHealthRatio() == 0 || (Integer)entry.getValue() >= 52) {
                    this.splitsMap.putIfAbsent(big, 255);
                    return true;
                }
                return false;
            });
        }
        if (!this.splitsMap.isEmpty()) {
            this.splitsMap.values().removeIf(VALUE_IS_ZERO);
            this.splitsMap.replaceAll(DECREMENT_VALUE);
        }
    }

    @Subscribe
    private void onAnimationChanged(AnimationChanged e) {
        if (!this.active() || !(e.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)e.getActor();
        if (NylocasConstants.isBigNylo(npc.getId())) {
            switch (npc.getAnimation()) {
                case 7991: 
                case 7998: 
                case 8005: {
                    this.splitsMap.merge(npc, 5, (o, n) -> n);
                    break;
                }
                case 7992: 
                case 8000: 
                case 8006: {
                    this.splitsMap.merge(npc, 3, (o, n) -> n);
                }
            }
        }
    }

    @Subscribe
    private void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (!this.active() || !this.config.nyloLowDetail()) {
            return;
        }
        GraphicsObject graphic = e.getGraphicsObject();
        int id = e.getGraphicsObject().getId();
        if (id >= 1561 && id <= 1564 || id >= 1891 && id <= 1894) {
            graphic.setFinished(true);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.instance.getCurrentRegion() != Region.NYLOCAS && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String stripped = Text.removeTags((String)event.getMessage());
        if (NylocasConstants.NYLOCAS_WAVE.matcher(stripped).find()) {
            this.dataHandler.setShouldTrack(false);
            this.dataHandler.Find("Room").get().setValue(this.dataHandler.getTime());
            if (this.config.displayRoomTimes().isInfobox()) {
                this.buildInfobox();
            }
            if (this.config.displayRoomTimes().isChat()) {
                this.sendChatTimes();
            }
        }
    }

    private void buildInfobox() {
        if (!this.dataHandler.getData().isEmpty()) {
            String tooltip = !this.dataHandler.Find("Starting Tick").get().isException() ? "Waves - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Waves")) + "</br>Cleanup - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Cleanup")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Cleanup"), this.dataHandler.FindValue("Waves")) + "</br>Boss - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Boss")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Boss"), this.dataHandler.FindValue("Cleanup")) + "</br>Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("Boss")) : "Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*";
            this.nylocasInfoBox = RoomInfoUtil.createInfoBox(this.plugin, this.config, (BufferedImage)this.itemManager.getImage(NylocasConstants.BOSS_IMAGE), "Nylocas", RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")), tooltip);
            this.infoBoxManager.addInfoBox((InfoBox)this.nylocasInfoBox);
        }
    }

    private void sendChatTimes() {
        if (!this.dataHandler.getData().isEmpty()) {
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Waves").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Waves")) + " - ").append(Color.RED, "Cleanup").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Cleanup")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Cleanup"), this.dataHandler.FindValue("Waves")) + " - ").append(Color.RED, "Boss").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Boss")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Boss"), this.dataHandler.FindValue("Cleanup"))));
                if (this.config.roomTimeValidation()) {
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Nylocas - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("Boss"))));
                }
            } else if (this.config.roomTimeValidation()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Nylocas - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*"));
            }
        }
    }

    private void hideRoomObjects(String option) {
        switch (option) {
            case "Pillars": {
                this.sceneManager.removeTheseGameObjects(this.client.getPlane(), (Collection<Integer>)ImmutableList.of((Object)32862));
                break;
            }
            case "Spectator Webs": {
                this.sceneManager.removeTheseGameObjects(this.client.getPlane(), (Collection<Integer>)ImmutableList.of((Object)32939, (Object)32865, (Object)32937));
                break;
            }
            case "Walls": {
                this.sceneManager.removeTheseGameObjects(this.client.getPlane(), (Collection<Integer>)ImmutableList.of((Object)32876, (Object)32899));
                break;
            }
            case "Pillars and Webs": {
                this.sceneManager.removeTheseGameObjects(this.client.getPlane(), (Collection<Integer>)ImmutableList.of((Object)32862, (Object)32939, (Object)32865, (Object)32937));
                break;
            }
            case "All": {
                this.sceneManager.removeTheseGameObjects(this.client.getPlane(), (Collection<Integer>)ImmutableList.of((Object)32862, (Object)32939, (Object)32865, (Object)32937, (Object)32876, (Object)32899));
            }
        }
    }

    public boolean isAnyRole() {
        return this.displayRoleMage || this.displayRoleMelee || this.displayRoleRange;
    }

    public NyloSelectionManager getNyloSelectionManager() {
        return this.nyloSelectionManager;
    }

    public boolean isDisplayRoleSelector() {
        return this.displayRoleSelector;
    }

    public boolean isDisplayRoleMage() {
        return this.displayRoleMage;
    }

    public void setDisplayRoleMage(boolean displayRoleMage) {
        this.displayRoleMage = displayRoleMage;
    }

    public boolean isDisplayRoleMelee() {
        return this.displayRoleMelee;
    }

    public void setDisplayRoleMelee(boolean displayRoleMelee) {
        this.displayRoleMelee = displayRoleMelee;
    }

    public boolean isDisplayRoleRange() {
        return this.displayRoleRange;
    }

    public void setDisplayRoleRange(boolean displayRoleRange) {
        this.displayRoleRange = displayRoleRange;
    }

    public boolean isDisplayInstanceTimer() {
        return this.displayInstanceTimer;
    }

    public NyloBoss getBoss() {
        return this.boss;
    }

    public NyloBoss getDemiBoss() {
        return this.demiBoss;
    }

    public Map<NPC, Integer> getPillars() {
        return this.pillars;
    }

    public Map<NPC, Integer> getWavesMap() {
        return this.wavesMap;
    }

    public Map<NPC, Integer> getBigsMap() {
        return this.bigsMap;
    }

    public Map<NPC, Integer> getSplitsMap() {
        return this.splitsMap;
    }
}

