/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.maiden.commons;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.maiden.commons.MaidenConstants;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import org.apache.commons.lang3.tuple.Pair;

public enum MaidenTable implements MaidenConstants
{
    MAIDEN_P0(10814, 8360, 10822),
    MAIDEN_P1(10815, 8361, 10823),
    MAIDEN_P2(10816, 8362, 10824),
    MAIDEN_P3(10817, 8363, 10825),
    MAIDEN_DESPAWN_0(10818, 8364, 10826),
    MAIDEN_DESPAWN_1(10819, 8365, 10827),
    BLOOD_SPAWN(10821, 8367, 10829),
    RED_CRAB(10820, 8366, 10828);

    private final int sm;
    private final int rg;
    private final int hm;
    private static final Table<Instance.Mode, Integer, MaidenTable> LOOKUP_TABLE;
    private static final Table<String, Integer, Boolean> SPAWNS_TABLE;

    @Nullable
    public static Instance.Mode findMode(int npcId) {
        return Instance.findFirstMode(mode -> LOOKUP_TABLE.get((Object)mode, (Object)npcId) != null);
    }

    @Nullable
    public static Pair<String, Boolean> lookupMatomenosSpawn(Client client, @Nullable NPC npc) {
        if (npc == null) {
            return null;
        }
        WorldPoint wp = WorldPoint.fromLocal((Client)client, (LocalPoint)npc.getLocalLocation());
        int packed = wp.getRegionX() << 8 | wp.getRegionY();
        for (String spawnKey : SPAWNS_TABLE.rowKeySet()) {
            Boolean scuffed = (Boolean)SPAWNS_TABLE.get((Object)spawnKey, (Object)packed);
            if (scuffed == null) continue;
            return Pair.of((Object)spawnKey, (Object)scuffed);
        }
        return null;
    }

    private MaidenTable(int sm, int rg, int hm) {
        this.sm = sm;
        this.rg = rg;
        this.hm = hm;
    }

    public int sm() {
        return this.sm;
    }

    public int rg() {
        return this.rg;
    }

    public int hm() {
        return this.hm;
    }

    static {
        ImmutableTable.Builder l_builder = ImmutableTable.builder();
        for (MaidenTable def : MaidenTable.values()) {
            l_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.STORY), (Object)def.sm, (Object)def));
            l_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.REGULAR), (Object)def.rg, (Object)def));
            l_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.HARD), (Object)def.hm, (Object)def));
        }
        LOOKUP_TABLE = l_builder.build();
        ImmutableTable.Builder s_builder = ImmutableTable.builder();
        s_builder.put(Tables.immutableCell((Object)"N1", (Object)5930, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"N1", (Object)5673, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"N2", (Object)6954, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"N2", (Object)6697, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"N3", (Object)7978, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"N3", (Object)7721, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"N4 (1)", (Object)9002, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"N4 (1)", (Object)8745, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"N4 (2)", (Object)9000, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"N4 (2)", (Object)8743, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"S1", (Object)5908, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"S1", (Object)5653, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"S2", (Object)6932, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"S2", (Object)6677, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"S3", (Object)7956, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"S3", (Object)7701, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"S4 (1)", (Object)8980, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"S4 (1)", (Object)8725, (Object)false));
        s_builder.put(Tables.immutableCell((Object)"S4 (2)", (Object)8982, (Object)true));
        s_builder.put(Tables.immutableCell((Object)"S4 (2)", (Object)8727, (Object)false));
        SPAWNS_TABLE = s_builder.build();
    }
}

