/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.maiden.commons;

import com.tobqol.api.game.Health;
import com.tobqol.api.game.Hitpoints;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.maiden.commons.MaidenPhase;
import com.tobqol.rooms.maiden.commons.MaidenTable;
import java.util.function.Predicate;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import org.apache.commons.lang3.tuple.Pair;

public class MaidenRedCrab
implements Predicate<NPC> {
    private final NPC npc;
    private final Health health;
    private final String phaseKey;
    private final String spawnKey;
    private final boolean scuffed;

    public MaidenRedCrab(Client client, Instance instance, NPC npc, MaidenPhase phase) {
        this.npc = npc;
        this.health = new Health(Hitpoints.MAIDEN_MATOMENOS.getBaseHP(instance));
        this.phaseKey = phase.key();
        Pair<String, Boolean> id = MaidenTable.lookupMatomenosSpawn(client, npc);
        this.spawnKey = id == null ? "Unknown" : (String)id.getLeft();
        this.scuffed = id != null && (Boolean)id.getRight() != false;
    }

    public int distance(Actor actor) {
        if (actor == null) {
            return -1;
        }
        return this.npc.getWorldArea().distanceTo2D(actor.getWorldArea()) - 1;
    }

    @Override
    public boolean test(NPC npc) {
        return npc != null && (npc == this.npc || npc.getIndex() == this.npc.getIndex());
    }

    public NPC npc() {
        return this.npc;
    }

    public Health health() {
        return this.health;
    }

    public String phaseKey() {
        return this.phaseKey;
    }

    public String spawnKey() {
        return this.spawnKey;
    }

    public boolean scuffed() {
        return this.scuffed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaidenRedCrab)) {
            return false;
        }
        MaidenRedCrab other = (MaidenRedCrab)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NPC this$npc = this.npc;
        NPC other$npc = other.npc;
        return !(this$npc == null ? other$npc != null : !this$npc.equals(other$npc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaidenRedCrab;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NPC $npc = this.npc;
        result = result * 59 + ($npc == null ? 43 : $npc.hashCode());
        return result;
    }
}

