/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.maiden.commons;

import com.google.common.collect.ImmutableMap;
import com.tobqol.rooms.maiden.commons.MaidenTable;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.NPC;

public enum MaidenPhase {
    P1("70s"),
    P2("50s"),
    P3("30s"),
    OTHER("*");

    private final String key;
    private static final Map<Integer, MaidenPhase> LOOKUP;

    public static MaidenPhase compose(NPC npc) {
        if (npc == null) {
            return OTHER;
        }
        return LOOKUP.getOrDefault(npc.getId(), OTHER);
    }

    public boolean isPhaseOne() {
        return this == P1;
    }

    public boolean isPhaseTwo() {
        return this == P2;
    }

    public boolean isPhaseThree() {
        return this == P3;
    }

    public boolean isNonTrackedPhase() {
        return this == OTHER;
    }

    private MaidenPhase(String key) {
        this.key = key;
    }

    public String key() {
        return this.key;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<MaidenTable, MaidenPhase> phases = new HashMap<MaidenTable, MaidenPhase>();
        phases.put(MaidenTable.MAIDEN_P0, P1);
        phases.put(MaidenTable.MAIDEN_P1, P2);
        phases.put(MaidenTable.MAIDEN_P2, P3);
        phases.forEach((table, phase) -> {
            builder.put((Object)table.sm(), (Object)phase);
            builder.put((Object)table.rg(), (Object)phase);
            builder.put((Object)table.hm(), (Object)phase);
        });
        LOOKUP = builder.build();
    }
}

