/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.maiden;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Health;
import com.tobqol.api.game.Instance;
import com.tobqol.config.HPDisplayTypes;
import com.tobqol.rooms.RoomSceneOverlay;
import com.tobqol.rooms.maiden.MaidenHandler;
import com.tobqol.rooms.maiden.commons.MaidenRedCrab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaidenSceneOverlay
extends RoomSceneOverlay<MaidenHandler> {
    private static final Logger log = LoggerFactory.getLogger(MaidenSceneOverlay.class);

    @Inject
    protected MaidenSceneOverlay(Client client, Instance instance, MaidenHandler room, TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(client, instance, room, plugin, config);
    }

    public Dimension render(Graphics2D graphics) {
        if (!((MaidenHandler)this.room).active()) {
            return null;
        }
        graphics.setFont(this.plugin.getPluginFont());
        this.drawCrabOverlays(graphics);
        return null;
    }

    private void drawCrabOverlays(Graphics2D graphics) {
        HPDisplayTypes hpDisplayType = this.config.getMaidenCrabHPType();
        if (hpDisplayType.off()) {
            return;
        }
        Multimap group = Multimaps.filterValues((Multimap)Multimaps.index(((MaidenHandler)this.room).getCrabsMap().values(), crab -> crab.npc().getWorldLocation()), crab -> !crab.health().zero());
        MaidenSceneOverlay.traverseMultimap(graphics, group, null, (wp, crab, i) -> this.drawCrabTextOverlays(graphics, (MaidenRedCrab)crab, (int)i));
    }

    private void drawCrabTextOverlays(Graphics2D graphics, MaidenRedCrab crab, int offset) {
        HPDisplayTypes hpDisplayType = this.config.getMaidenCrabHPType();
        ArrayList<String> pieces = new ArrayList<String>();
        NPC npc = crab.npc();
        if (!hpDisplayType.off()) {
            Health health = crab.health();
            pieces.add(hpDisplayType.showAsPercent() ? Double.toString(health.truncatedPercent()) : Integer.toString(health.getCurrent()));
        }
        if (pieces.isEmpty()) {
            return;
        }
        String text = Strings.join(pieces, (String)" | ");
        Point textLocation = npc.getCanvasTextLocation(graphics, text, 0);
        if (textLocation == null) {
            return;
        }
        Color color = Optional.ofNullable(Color.WHITE).orElse(crab.health().color());
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLocation.getX(), textLocation.getY() - offset), (String)text, (Color)color);
    }
}

