/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.maiden;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.maiden.MaidenSceneOverlay;
import com.tobqol.rooms.maiden.commons.MaidenConstants;
import com.tobqol.rooms.maiden.commons.MaidenHealth;
import com.tobqol.rooms.maiden.commons.MaidenPhase;
import com.tobqol.rooms.maiden.commons.MaidenRedCrab;
import com.tobqol.rooms.maiden.commons.MaidenTable;
import com.tobqol.tracking.RoomDataHandler;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoBox;
import com.tobqol.tracking.RoomInfoUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaidenHandler
extends RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(MaidenHandler.class);
    @Inject
    private MaidenSceneOverlay sceneOverlay;
    private RoomDataHandler dataHandler;
    @CheckForNull
    private NPC maidenNpc = null;
    private RoomInfoBox maidenInfoBox;
    @CheckForNull
    private MaidenHealth health = null;
    private MaidenPhase phase = MaidenPhase.OTHER;
    private final List<NPC> bloodSpawns = new ArrayList<NPC>();
    private final Map<Integer, MaidenRedCrab> crabsMap = new HashMap<Integer, MaidenRedCrab>();
    private final List<MaidenRedCrab> crabs_buffer = new ArrayList<MaidenRedCrab>();
    private byte totalLeaks = 0;
    private boolean considerCrabs = true;

    @Inject
    protected MaidenHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(plugin, config);
        this.setRoomRegion(Region.MAIDEN);
    }

    @Override
    public void load() {
        this.dataHandler = this.plugin.getDataHandler();
        this.overlayManager.add((Overlay)this.sceneOverlay);
    }

    @Override
    public void unload() {
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.reset();
    }

    @Override
    public void reset() {
        this.maidenNpc = null;
        this.phase = MaidenPhase.OTHER;
        this.bloodSpawns.clear();
        this.crabsMap.clear();
        this.crabs_buffer.clear();
        this.totalLeaks = 0;
        this.considerCrabs = true;
        if (this.instance.getRaidStatus() <= 1) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.maidenInfoBox);
        }
    }

    @Override
    public boolean active() {
        return Region.inRegion(this.client, Region.MAIDEN) && this.maidenNpc != null && !this.maidenNpc.isDead();
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        NPC npc = e.getNpc();
        if (this.active()) {
            MaidenHandler.isNpcFromName(npc, "Blood spawn", n -> this.bloodSpawns.add(npc));
            MaidenHandler.isNpcFromName(npc, "Nylocas Matomenos", n -> {
                this.crabsMap.put(n.getIndex(), new MaidenRedCrab(this.client, this.instance, (NPC)n, this.phase));
                if (!this.dataHandler.getData().isEmpty() & this.considerCrabs) {
                    this.considerCrabs = false;
                    if (!this.dataHandler.Find("70s").isPresent()) {
                        this.dataHandler.getData().add(new RoomDataItem("70s", this.dataHandler.getTime(), 1, !this.config.displayTimeSplits()));
                        return;
                    }
                    if (!this.dataHandler.Find("50s").isPresent() && this.dataHandler.Find("70s").isPresent()) {
                        this.dataHandler.getData().add(new RoomDataItem("50s", this.dataHandler.getTime(), 2, !this.config.displayTimeSplits(), "70s"));
                        return;
                    }
                    if (!this.dataHandler.Find("30s").isPresent() && this.dataHandler.Find("50s").isPresent()) {
                        this.dataHandler.getData().add(new RoomDataItem("30s", this.dataHandler.getTime(), 3, !this.config.displayTimeSplits(), "50s"));
                        return;
                    }
                }
            });
            return;
        }
        MaidenHandler.isNpcFromName(npc, "The Maiden of Sugadinti", n -> {
            if (!this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                this.dataHandler.setShouldTrack(true);
                this.dataHandler.getData().add(new RoomDataItem("Room", this.dataHandler.getTime(), 99, false, "30s"));
            }
            this.instance.lazySetMode(() -> MaidenTable.findMode(n.getId()));
            this.maidenNpc = n;
            this.phase = MaidenPhase.compose(n);
        });
    }

    @Subscribe
    private void onNpcChanged(NpcChanged e) {
        if (!this.active()) {
            return;
        }
        MaidenHandler.isNpcFromName(e.getNpc(), "The Maiden of Sugadinti", n -> {
            this.phase = MaidenPhase.compose(n);
        });
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (!this.active()) {
            return;
        }
        NPC npc = e.getNpc();
        if (MaidenHandler.isNpcFromName(npc, "The Maiden of Sugadinti", $ -> this.reset())) {
            return;
        }
        MaidenHandler.isNpcFromName(npc, "Blood spawn", n -> this.bloodSpawns.removeIf(s -> s != null && npc.getIndex() == s.getIndex()));
        MaidenHandler.isNpcFromName(npc, "Nylocas Matomenos", n -> {
            this.crabsMap.remove(n.getIndex());
            this.crabs_buffer.removeIf(crab -> crab.test((NPC)n));
        });
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.instance.isInRaid() && this.instance.getCurrentRegion().isMaiden()) {
            if (this.instance.getRoomStatus() == 1 && !this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true, true));
                this.dataHandler.setShouldTrack(true);
            }
            if (this.dataHandler.isShouldTrack() && !this.dataHandler.getData().isEmpty()) {
                this.dataHandler.updateTotalTime();
            }
        }
        if (!this.active()) {
            return;
        }
        if (!this.considerCrabs) {
            this.considerCrabs = true;
        }
        if (!this.crabs_buffer.isEmpty()) {
            this.crabs_buffer.removeIf(crab -> {
                if (crab.distance((Actor)this.maidenNpc) == 0 && !crab.health().zero()) {
                    if (this.config.displayMaidenLeaks()) {
                        this.enqueueChatMessage(ChatMessageType.FRIENDNOTIFICATION, (ChatMessageBuilder b) -> b.append(Color.BLUE, "[" + crab.phaseKey() + "]").append(ChatColorType.NORMAL).append(" - " + crab.spawnKey() + " leaked with ").append(Color.RED, crab.health().truncatedPercent() + "%").append(ChatColorType.NORMAL).append(" hitpoints!"));
                    }
                    this.totalLeaks = (byte)(this.totalLeaks + 1);
                }
                return true;
            });
        }
    }

    @Subscribe
    private void onAnimationChanged(AnimationChanged e) {
        if (!this.active() || !(e.getActor() instanceof NPC)) {
            return;
        }
        MaidenHandler.isNpcFromName((NPC)e.getActor(), "The Maiden of Sugadinti", n -> {
            switch (n.getAnimation()) {
                case -1: {
                    break;
                }
                case 8093: {
                    this.reset();
                }
            }
        });
        MaidenHandler.isNpcFromName((NPC)e.getActor(), "Nylocas Matomenos", n -> {
            if (n.getAnimation() == 8097) {
                Optional.ofNullable(this.crabsMap.getOrDefault(n.getIndex(), null)).ifPresent(this.crabs_buffer::add);
            }
        });
    }

    @Subscribe
    private void onHitsplatApplied(HitsplatApplied e) {
        if (!this.active() || !(e.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)e.getActor();
        Hitsplat hitsplat = e.getHitsplat();
        int amount = hitsplat.getAmount();
        MaidenHandler.isNpcFromName(npc, "The Maiden of Sugadinti", n -> {
            if (hitsplat.isMine() || hitsplat.isOthers()) {
                Optional.ofNullable(this.health).ifPresent(h -> h.removeHealth(amount));
                return;
            }
        });
        MaidenHandler.isNpcFromName(npc, "Nylocas Matomenos", n -> {
            MaidenRedCrab crab = this.crabsMap.getOrDefault(n.getIndex(), null);
            if (crab == null || !hitsplat.isMine() && !hitsplat.isOthers()) {
                return;
            }
            crab.health().removeHealth(amount);
        });
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.instance.getCurrentRegion() != Region.MAIDEN && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String stripped = Text.removeTags((String)event.getMessage());
        if (MaidenConstants.MAIDEN_WAVE.matcher(stripped).find()) {
            this.dataHandler.setShouldTrack(false);
            this.dataHandler.Find("Room").get().setValue(this.dataHandler.getTime());
            if (this.config.displayRoomTimes().isInfobox()) {
                this.buildInfobox();
            }
            if (this.config.displayRoomTimes().isChat()) {
                this.sendChatTimes();
            }
        }
    }

    private void buildInfobox() {
        if (!this.dataHandler.getData().isEmpty()) {
            String tooltip = !this.dataHandler.Find("Starting Tick").get().isException() ? "70% - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("70s")) + "</br>50% - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("50s")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("50s"), this.dataHandler.FindValue("70s")) + "</br>30% - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("30s")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("30s"), this.dataHandler.FindValue("50s")) + "</br>Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("30s")) : "Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*";
            this.maidenInfoBox = RoomInfoUtil.createInfoBox(this.plugin, this.config, (BufferedImage)this.itemManager.getImage(25748), "Maiden", RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")), tooltip);
            this.infoBoxManager.addInfoBox((InfoBox)this.maidenInfoBox);
        }
    }

    private void sendChatTimes() {
        if (!this.dataHandler.getData().isEmpty()) {
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "70%").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("70s")) + " - ").append(Color.RED, "50%").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("50s")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("50s"), this.dataHandler.FindValue("70s")) + " - ").append(Color.RED, "30%").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("30s")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("30s"), this.dataHandler.FindValue("50s"))));
                if (this.config.roomTimeValidation()) {
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Maiden - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("30%"))));
                }
            } else if (this.config.roomTimeValidation()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Maiden - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*"));
            }
        }
    }

    public MaidenSceneOverlay getSceneOverlay() {
        return this.sceneOverlay;
    }

    public RoomDataHandler getDataHandler() {
        return this.dataHandler;
    }

    @CheckForNull
    public NPC getMaidenNpc() {
        return this.maidenNpc;
    }

    public RoomInfoBox getMaidenInfoBox() {
        return this.maidenInfoBox;
    }

    @CheckForNull
    public MaidenHealth getHealth() {
        return this.health;
    }

    public MaidenPhase getPhase() {
        return this.phase;
    }

    public List<NPC> getBloodSpawns() {
        return this.bloodSpawns;
    }

    public Map<Integer, MaidenRedCrab> getCrabsMap() {
        return this.crabsMap;
    }

    public boolean isConsiderCrabs() {
        return this.considerCrabs;
    }
}

