/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.bloat.commons;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.bloat.commons.BloatConstants;

public enum BloatTable implements BloatConstants
{
    BLOAT(10812, 8359, 10813);

    private final int sm;
    private final int rg;
    private final int hm;
    private static final Table<Instance.Mode, Integer, BloatTable> LOOKUP_TABLE;

    public static Instance.Mode findMode(int npcId) {
        return Instance.findFirstMode(mode -> LOOKUP_TABLE.get((Object)mode, (Object)npcId) != null);
    }

    private BloatTable(int sm, int rg, int hm) {
        this.sm = sm;
        this.rg = rg;
        this.hm = hm;
    }

    static {
        ImmutableTable.Builder l_builder = ImmutableTable.builder();
        for (BloatTable def : BloatTable.values()) {
            l_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.STORY), (Object)def.sm, (Object)def));
            l_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.REGULAR), (Object)def.rg, (Object)def));
            l_builder.put(Tables.immutableCell((Object)((Object)Instance.Mode.HARD), (Object)def.hm, (Object)def));
        }
        LOOKUP_TABLE = l_builder.build();
    }
}

