/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.bloat;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.bloat.commons.BloatConstants;
import com.tobqol.rooms.bloat.commons.BloatTable;
import com.tobqol.tracking.RoomDataHandler;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoBox;
import com.tobqol.tracking.RoomInfoUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloatHandler
extends RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(BloatHandler.class);
    private RoomDataHandler dataHandler;
    @CheckForNull
    private NPC bloatNpc = null;
    private RoomInfoBox bloatInfoBox;
    private int downs = 0;

    @Inject
    protected BloatHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(plugin, config);
        this.setRoomRegion(Region.BLOAT);
        this.dataHandler = plugin.getDataHandler();
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
        this.reset();
    }

    @Override
    public void reset() {
        this.bloatNpc = null;
        if (this.instance.getRaidStatus() <= 1) {
            this.downs = 0;
            this.infoBoxManager.removeInfoBox((InfoBox)this.bloatInfoBox);
        }
    }

    @Override
    public boolean active() {
        return Region.inRegion(this.client, Region.BLOAT);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("tobqol")) {
            return;
        }
        switch (e.getKey()) {
            case "hideCeilingChains": {
                BloatHandler.when(this.config.shouldNullCeilingChains(), this::nullCeilingChains, this.sceneManager::refreshScene);
            }
        }
    }

    @Subscribe(priority=-1.0f)
    private void onGameStateChanged(GameStateChanged e) {
        if (!this.active() || e.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        BloatHandler.when(this.config.shouldNullCeilingChains(), this::nullCeilingChains, null);
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        if (!this.active() || this.bloatNpc != null) {
            return;
        }
        BloatHandler.isNpcFromName(e.getNpc(), "Pestilent Bloat", n -> {
            this.instance.lazySetMode(() -> BloatTable.findMode(n.getId()));
            this.bloatNpc = n;
        });
        BloatHandler.when(this.config.shouldNullCeilingChains(), this::nullCeilingChains, null);
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (!this.active()) {
            return;
        }
        BloatHandler.isNpcFromName(e.getNpc(), "Pestilent Bloat", $ -> this.reset());
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        if (this.instance.isInRaid() && this.instance.getCurrentRegion().isBloat()) {
            if (!this.dataHandler.Find("Starting Tick").isPresent() && BloatHandler.crossedLine(Region.BLOAT, new Point(39, 30), new Point(39, 33), true, this.client)) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                this.dataHandler.setShouldTrack(true);
            }
            if (!this.dataHandler.getData().isEmpty() && this.dataHandler.isShouldTrack()) {
                this.dataHandler.updateTotalTime();
            }
        }
    }

    @Subscribe
    private void onVarbitChanged(VarbitChanged event) {
        if (this.instance.isInRaid() && this.instance.getCurrentRegion().isBloat() && !this.dataHandler.Find("Starting Tick").isPresent() && this.client.getVarbitValue(6447) == 1) {
            this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true, true));
            this.dataHandler.setShouldTrack(true);
        }
    }

    @Subscribe
    private void onAnimationChanged(AnimationChanged e) {
        if (!this.active() || !(e.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)e.getActor();
        if (npc == this.bloatNpc && npc.getAnimation() == 8082) {
            ++this.downs;
            this.dataHandler.getData().add(new RoomDataItem("Down " + this.downs, this.dataHandler.getTime(), this.downs, true));
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.active() || event.getType() != ChatMessageType.GAMEMESSAGE || !this.dataHandler.Find("Starting Tick").isPresent()) {
            return;
        }
        String stripped = Text.removeTags((String)event.getMessage());
        if (BloatConstants.BLOAT_WAVE.matcher(stripped).find()) {
            this.dataHandler.setShouldTrack(false);
            this.dataHandler.Find("Room").get().setValue(this.dataHandler.getTime());
            if (this.config.displayRoomTimes().isInfobox()) {
                this.buildInfobox();
            }
            if (this.config.displayRoomTimes().isChat()) {
                this.sendChatTimes();
            }
        }
    }

    private void nullCeilingChains() {
        this.sceneManager.removeTheseGameObjects(1, (Collection<Integer>)BloatTable.CEILING_CHAINS);
    }

    private void buildInfobox() {
        if (this.dataHandler.FindValue("Starting Tick") > 0) {
            String roomTime = RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"));
            StringBuilder tooltip = new StringBuilder();
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                if (this.config.trackDowns()) {
                    if (this.downs > 0) {
                        this.dataHandler.getData().forEach(d -> {
                            if (d.getName().contains("Down")) {
                                tooltip.append(d.getName() + " - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Down " + d.getSort())) + (d.getSort() > 1 ? RoomInfoUtil.formatTime(this.dataHandler.FindValue("Down " + d.getSort()), this.dataHandler.FindValue("Down " + (d.getSort() - 1))) : "") + "</br>");
                            }
                        });
                    } else {
                        tooltip.append("No downs");
                    }
                }
                tooltip.append("Complete - " + roomTime);
            } else {
                tooltip.append("Complete - " + roomTime + "*");
            }
            this.bloatInfoBox = RoomInfoUtil.createInfoBox(this.plugin, this.config, (BufferedImage)this.itemManager.getImage(25749), "Bloat", roomTime, tooltip.toString());
            this.plugin.infoBoxManager.addInfoBox((InfoBox)this.bloatInfoBox);
        }
    }

    private void sendChatTimes() {
        if (this.dataHandler.Find("Starting Tick").isPresent()) {
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                if (this.downs > 0 && this.config.trackDowns()) {
                    ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder();
                    int downsRemaining = this.downs - 1;
                    for (RoomDataItem d : this.dataHandler.getData()) {
                        if (!d.getName().contains("Down")) continue;
                        chatMessageBuilder.append(Color.RED, d.getName()).append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(d.getValue()) + (d.getSort() > 1 ? RoomInfoUtil.formatTime(d.getValue(), this.dataHandler.FindValue("Down " + (d.getSort() - 1))) : "") + (downsRemaining > 0 ? " - " : ""));
                        --downsRemaining;
                    }
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, chatMessageBuilder);
                }
                if (this.config.roomTimeValidation()) {
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Bloat - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("Down " + this.downs))));
                }
            } else if (this.config.roomTimeValidation()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Bloat - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*"));
            }
        }
    }

    public RoomDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public RoomInfoBox getBloatInfoBox() {
        return this.bloatInfoBox;
    }

    public int getDowns() {
        return this.downs;
    }

    @CheckForNull
    public NPC getBloatNpc() {
        return this.bloatNpc;
    }
}

