/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms;

import com.google.common.collect.Multimap;
import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Instance;
import com.tobqol.api.util.TriConsumer;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.sotetseg.commons.SotetsegTable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoomSceneOverlay<R extends RoomHandler>
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(RoomSceneOverlay.class);
    protected final Client client;
    protected final Instance instance;
    protected final R room;
    protected final TheatreQOLPlugin plugin;
    protected final TheatreQOLConfig config;

    @Inject
    protected RoomSceneOverlay(Client client, Instance instance, R room, TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        this.client = client;
        this.instance = instance;
        this.room = room;
        this.plugin = plugin;
        this.config = config;
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    protected final void drawInstanceTimer(Graphics2D graphics, @Nullable NPC npc, @Nullable TileObject tileObject) {
        Point npcLocation;
        Point tileObjectLocation;
        int tickCycle = this.instance.getTickCycle();
        if (tickCycle == -1) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        String text = Integer.toString(tickCycle);
        Color color = npc != null && (SotetsegTable.anyMatch(SotetsegTable.SOTETSEG_CLICKABLE, npc.getId()) || SotetsegTable.anyMatch(SotetsegTable.SOTETSEG_NOT_CLICKABLE, npc.getId())) ? (tickCycle == 3 ? Color.GREEN.brighter() : Color.RED.brighter()) : (tickCycle > 0 ? Color.RED.brighter() : Color.GREEN.brighter());
        Point textLocation = player.getCanvasTextLocation(graphics, text, player.getLogicalHeight() + 60 + this.config.instanceTimerOffset() * 10);
        if (textLocation != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)color);
        }
        if (tileObject != null && (tileObjectLocation = tileObject.getCanvasTextLocation(graphics, text, 50)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)tileObjectLocation, (String)text, (Color)color);
        }
        if (npc != null && (npcLocation = npc.getCanvasTextLocation(graphics, text, 50)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)npcLocation, (String)text, (Color)color);
        }
    }

    public static <K, V> void traverseMultimap(Graphics2D graphics, Multimap<K, V> multimap, BiConsumer<K, Integer> before, TriConsumer<K, V, Integer> after) {
        if (multimap == null || multimap.isEmpty()) {
            return;
        }
        for (Object k : multimap.keys()) {
            int offset = 0;
            if (k != null && before != null) {
                before.accept(k, offset);
            }
            for (Object v : multimap.get(k)) {
                if (k != null && v != null && after != null) {
                    after.accept(k, v, offset);
                }
                offset += graphics.getFontMetrics().getHeight();
            }
        }
    }
}

