/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms;

import com.google.common.base.Strings;
import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Instance;
import com.tobqol.api.game.Region;
import com.tobqol.api.game.SceneManager;
import java.io.BufferedInputStream;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(RoomHandler.class);
    public static final Predicate<Integer> VALUE_IS_ZERO = v -> v <= 0;
    public static final BiFunction<Object, Integer, Integer> INCREMENT_VALUE = (k, v) -> {
        v = v + 1;
        return v;
    };
    public static final BiFunction<Object, Integer, Integer> DECREMENT_VALUE = (k, v) -> {
        v = v - 1;
        return v;
    };
    protected final TheatreQOLPlugin plugin;
    protected final TheatreQOLConfig config;
    @Inject
    protected Client client;
    @Inject
    protected ClientThread clientThread;
    @Inject
    protected OverlayManager overlayManager;
    @Inject
    protected Instance instance;
    @Inject
    protected SceneManager sceneManager;
    @Inject
    protected ChatMessageManager chatMessageManager;
    @Inject
    protected ItemManager itemManager;
    @Inject
    protected InfoBoxManager infoBoxManager;
    private Region roomRegion = Region.UNKNOWN;

    @Inject
    protected RoomHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    public void init() {
    }

    public abstract void load();

    public abstract void unload();

    public boolean active() {
        return false;
    }

    public abstract void reset();

    protected final void setRoomRegion(Region region) {
        if (!this.roomRegion.isUnknown()) {
            return;
        }
        if (region == null) {
            this.roomRegion = Region.UNKNOWN;
            return;
        }
        switch (region) {
            case LOBBY: {
                this.roomRegion = Region.MAIDEN;
                break;
            }
            case SOTETSEG_MAZE: {
                this.roomRegion = Region.SOTETSEG;
                break;
            }
            default: {
                this.roomRegion = region;
            }
        }
    }

    protected final boolean isInRoomRegion() {
        if (this.roomRegion.isUnknown()) {
            return false;
        }
        Region current = this.instance.getCurrentRegion();
        return this.roomRegion.equals((Object)current) || this.roomRegion.isSotetseg() && current.isSotetseg();
    }

    protected static boolean isNpcFromName(NPC npc, String name) {
        if (npc == null || Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        String _name = npc.getName();
        return !Strings.isNullOrEmpty((String)_name) && _name.equals(name);
    }

    protected static boolean isNpcFromName(NPC npc, String name, Consumer<NPC> action) {
        if (RoomHandler.isNpcFromName(npc, name)) {
            if (action != null) {
                action.accept(npc);
            }
            return true;
        }
        return false;
    }

    protected static void when(boolean condition, Runnable success, Runnable failure) {
        if (condition) {
            Optional.ofNullable(success).ifPresent(Runnable::run);
            return;
        }
        Optional.ofNullable(failure).ifPresent(Runnable::run);
    }

    @Nullable
    protected final MessageNode sendChatMessage(ChatMessageType type, String message) {
        if (type == null || Strings.isNullOrEmpty((String)message)) {
            return null;
        }
        return this.client.addChatMessage(type, "", message, "", false);
    }

    protected final void enqueueChatMessage(ChatMessageType type, Consumer<ChatMessageBuilder> user) {
        if (type == null || user == null) {
            return;
        }
        ChatMessageBuilder builder = new ChatMessageBuilder();
        user.accept(builder);
        String message = builder.build();
        if (Strings.isNullOrEmpty((String)message)) {
            return;
        }
        this.chatMessageManager.queue(QueuedMessage.builder().type(type).runeLiteFormattedMessage(message).build());
    }

    protected final void enqueueChatMessage(ChatMessageType type, ChatMessageBuilder builder) {
        if (type == null || builder == null) {
            return;
        }
        String message = builder.build();
        if (Strings.isNullOrEmpty((String)message)) {
            return;
        }
        this.chatMessageManager.queue(QueuedMessage.builder().type(type).runeLiteFormattedMessage(message).build());
    }

    public static boolean crossedLine(Region region, Point start, Point end, boolean vertical, Client client) {
        if (Region.inRegion(client, region)) {
            for (Player p : client.getPlayers()) {
                int i;
                WorldPoint wp = p.getWorldLocation();
                if (vertical) {
                    for (i = start.getY(); i < end.getY() + 1; ++i) {
                        if (wp.getRegionY() != i || wp.getRegionX() != start.getX()) continue;
                        return true;
                    }
                    continue;
                }
                for (i = start.getX(); i < end.getX() + 1; ++i) {
                    if (wp.getRegionX() != i || wp.getRegionY() != start.getY()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Clip generateSoundClip(String clipName, int volume) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(new BufferedInputStream(TheatreQOLPlugin.class.getResourceAsStream(clipName)));
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip soundClip = (Clip)AudioSystem.getLine(info);
            soundClip.open(stream);
            FloatControl control = (FloatControl)soundClip.getControl(FloatControl.Type.MASTER_GAIN);
            if (control != null) {
                control.setValue(volume / 2 - 45);
            }
            return soundClip;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Region getRoomRegion() {
        return this.roomRegion;
    }
}

