/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.api.util;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.rooms.nylocas.NylocasHandler;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import net.runelite.client.input.MouseAdapter;

public class TheatreInputListener
extends MouseAdapter {
    @Inject
    private TheatreQOLConfig config;
    @Inject
    private NylocasHandler nylocas;

    public MouseEvent mouseReleased(MouseEvent event) {
        if (this.nylocas.getNyloSelectionManager().isHidden()) {
            return event;
        }
        if (this.nylocas.getNyloSelectionManager().getBounds().contains(event.getPoint())) {
            event.consume();
            return event;
        }
        return event;
    }

    public MouseEvent mousePressed(MouseEvent event) {
        if (this.nylocas.getNyloSelectionManager().isHidden()) {
            return event;
        }
        if (this.nylocas.getNyloSelectionManager().getBounds().contains(event.getPoint())) {
            event.consume();
            return event;
        }
        return event;
    }

    public MouseEvent mouseClicked(MouseEvent event) {
        if (this.nylocas.getNyloSelectionManager().isHidden()) {
            return event;
        }
        if (event.getButton() == 1 && this.nylocas.getNyloSelectionManager().getBounds().contains(event.getPoint())) {
            if (this.nylocas.getNyloSelectionManager().getMeleeBounds().contains(event.getPoint())) {
                boolean updated = !this.config.nyloRoleSelectedMelee();
                this.config.nyloSetRoleSelectedMelee(updated);
                this.nylocas.getNyloSelectionManager().getMelee().setSelected(updated);
                this.nylocas.setDisplayRoleMelee(updated);
            } else if (this.nylocas.getNyloSelectionManager().getRangeBounds().contains(event.getPoint())) {
                boolean updated = !this.config.nyloRoleSelectedRange();
                this.config.nyloSetRoleSelectedRange(updated);
                this.nylocas.getNyloSelectionManager().getRange().setSelected(updated);
                this.nylocas.setDisplayRoleRange(updated);
            } else if (this.nylocas.getNyloSelectionManager().getMageBounds().contains(event.getPoint())) {
                boolean updated = !this.config.nyloRoleSelectedMage();
                this.config.nyloSetRoleSelectedMage(updated);
                this.nylocas.getNyloSelectionManager().getMage().setSelected(updated);
                this.nylocas.setDisplayRoleMage(updated);
            }
            event.consume();
        }
        return event;
    }

    public MouseEvent mouseMoved(MouseEvent event) {
        if (this.nylocas.getNyloSelectionManager().isHidden()) {
            return event;
        }
        this.nylocas.getNyloSelectionManager().getMelee().setHovered(false);
        this.nylocas.getNyloSelectionManager().getRange().setHovered(false);
        this.nylocas.getNyloSelectionManager().getMage().setHovered(false);
        if (this.nylocas.getNyloSelectionManager().getBounds().contains(event.getPoint())) {
            if (this.nylocas.getNyloSelectionManager().getMeleeBounds().contains(event.getPoint())) {
                this.nylocas.getNyloSelectionManager().getMelee().setHovered(true);
            } else if (this.nylocas.getNyloSelectionManager().getRangeBounds().contains(event.getPoint())) {
                this.nylocas.getNyloSelectionManager().getRange().setHovered(true);
            } else if (this.nylocas.getNyloSelectionManager().getMageBounds().contains(event.getPoint())) {
                this.nylocas.getNyloSelectionManager().getMage().setHovered(true);
            }
        }
        return event;
    }
}

