/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.api.game;

import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;

@Singleton
public class SceneManager {
    private final Client client;
    private final ClientThread clientThread;

    @Inject
    SceneManager(Client client, ClientThread clientThread) {
        this.client = client;
        this.clientThread = clientThread;
    }

    public void refreshScene() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.clientThread.invoke(() -> this.client.setGameState(GameState.LOADING));
    }

    public void forEachTile(int plane, BiConsumer<Scene, Tile> user) {
        if (plane < 0 || plane >= 4 || user == null || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][] tiles = scene.getTiles()[plane];
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[x][y];
                if (tile == null) continue;
                user.accept(scene, tile);
            }
        }
    }

    public void removeThisTile(int plane, int sceneX, int sceneY) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (plane < 0 || plane >= 4) {
            return;
        }
        if (sceneX < 0 || sceneX >= 104) {
            return;
        }
        if (sceneY < 0 || sceneY >= 104) {
            return;
        }
        if (this.client.isClientThread()) {
            this.client.getScene().getTiles()[plane][sceneX][sceneY] = null;
            return;
        }
        this.clientThread.invoke(() -> {
            this.client.getScene().getTiles()[plane][sceneX][sceneY] = null;
        });
    }

    public void removeThisTile(WorldPoint worldPoint) {
        if (worldPoint == null) {
            return;
        }
        this.removeThisTile(worldPoint.getPlane(), worldPoint.getX() - this.client.getBaseX(), worldPoint.getY() - this.client.getBaseY());
    }

    private void removeTheseGameObjects(int plane, int ... gameObjectIds) {
        if (gameObjectIds.length == 0 || plane < 0 || plane > 3) {
            return;
        }
        this.forEachTile(plane, (scene, tile) -> {
            GameObject[] arr = tile.getGameObjects();
            if (arr == null || arr.length == 0) {
                return;
            }
            block0: for (GameObject o : arr) {
                if (o == null) continue;
                for (int id : gameObjectIds) {
                    if (o.getId() != id) continue;
                    scene.removeGameObject(o);
                    continue block0;
                }
            }
        });
    }

    public void removeTheseGameObjects(int plane, Collection<Integer> gameObjectIds) {
        if (gameObjectIds == null || gameObjectIds.isEmpty()) {
            return;
        }
        if (this.client.isClientThread()) {
            this.removeTheseGameObjects(plane, Ints.toArray(gameObjectIds));
            return;
        }
        this.clientThread.invoke(() -> this.removeTheseGameObjects(plane, Ints.toArray((Collection)gameObjectIds)));
    }

    private void removeTheseGroundObjects(int plane, int ... groundObjectIds) {
        if (plane < 0 || plane > 3) {
            return;
        }
        this.forEachTile(plane, (scene, tile) -> {
            GroundObject object = tile.getGroundObject();
            if (object != null) {
                tile.setGroundObject(null);
            }
        });
    }

    public void removeTheseGroundObjects(int plane, Collection<Integer> groundObjectIds) {
        if (groundObjectIds == null || groundObjectIds.isEmpty() || plane < 0 || plane > 3) {
            return;
        }
        if (this.client.isClientThread()) {
            this.removeTheseGroundObjects(plane, Ints.toArray(groundObjectIds));
            return;
        }
        this.clientThread.invoke(() -> this.removeTheseGroundObjects(plane, Ints.toArray((Collection)groundObjectIds)));
    }
}

