/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.api.game;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public enum Region {
    LOBBY("Lobby", 12869, 0, 400, 552),
    MAIDEN("Maiden", 12613, 0, 392, 552, new WorldArea(3175, 4421, 4, 1, 0)),
    BLOAT("Bloat", 13125, 0, 408, 552, new WorldArea(3268, 4446, 1, 4, 0)),
    NYLOCAS("Nylocas Vasilias", 13122, 0, 408, 528, new WorldArea(3304, 4274, 1, 4, 0)),
    SOTETSEG("Sotetseg", 13123, 0, 408, 536, new WorldArea(3278, 4292, 4, 1, 0)),
    SOTETSEG_MAZE("Sotetseg", 13379, 3, 416, 536),
    XARPUS("Xarpus", 12612, 1, 392, 544, new WorldArea(3169, 4400, 3, 1, 1)),
    VERZIK("Verzik Vitur", 12611, 0, 392, 536),
    LOOT_ROOM("Loot Room", 12867, 0, 400, 536),
    UNKNOWN("Unknown");

    private final String prettyName;
    private final int regionId;
    private final int zone;
    @Nullable
    private final WorldArea imaginaryLine;
    private static final Map<Integer, Region> lookupMap;

    public static Region of(int regionId) {
        return lookupMap.getOrDefault(regionId, UNKNOWN);
    }

    public static boolean inRegion(Client client, Region region) {
        return Region.getCurrentRegionID(client, client.getLocalPlayer()) == region.regionId;
    }

    public static int getCurrentRegionID(Client client, Player player) {
        if (!client.isInInstancedRegion() || player == null) {
            return -1;
        }
        WorldPoint location = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)player.getLocalLocation());
        if (location == null) {
            return -1;
        }
        return location.getRegionID();
    }

    private Region(String prettyName, int regionID, int p, int x, int y, WorldArea imaginaryLine) {
        this(prettyName, regionID, p << 24 | x << 14 | y << 3, imaginaryLine);
    }

    private Region(String prettyName, int regionID, int p, int x, int y) {
        this(prettyName, regionID, p, x, y, null);
    }

    private Region(String prettyName) {
        this(prettyName, -1, -1, null);
    }

    public Region next() {
        if (this == SOTETSEG) {
            return XARPUS;
        }
        if (this == UNKNOWN) {
            return this;
        }
        Region[] regions = Region.values();
        int index = this.ordinal() + 1;
        return index >= regions.length ? UNKNOWN : regions[index];
    }

    public boolean isPCIL(Client client, Player player) {
        if (!client.isInInstancedRegion() || player == null || this.imaginaryLine == null) {
            return false;
        }
        try {
            LocalPoint lp = LocalPoint.fromWorld((Client)client, (WorldPoint)player.getWorldLocation());
            if (lp == null) {
                return false;
            }
            WorldPoint wp = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)lp);
            return wp != null && this.imaginaryLine.distanceTo2D(wp) <= 0;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    public boolean isLobby() {
        return this == LOBBY;
    }

    public boolean isMaiden() {
        return this == MAIDEN;
    }

    public boolean isBloat() {
        return this == BLOAT;
    }

    public boolean isNylocas() {
        return this == NYLOCAS;
    }

    public boolean isSotetseg() {
        return this == SOTETSEG || this == SOTETSEG_MAZE;
    }

    public boolean isSotetsegOverworld() {
        return this == SOTETSEG;
    }

    public boolean isSotetsegUnderworld() {
        return this == SOTETSEG_MAZE;
    }

    public boolean isXarpus() {
        return this == XARPUS;
    }

    public boolean isVerzik() {
        return this == VERZIK;
    }

    public boolean isLootRoom() {
        return this == LOOT_ROOM;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    private Region(String prettyName, @Nullable int regionId, int zone, WorldArea imaginaryLine) {
        this.prettyName = prettyName;
        this.regionId = regionId;
        this.zone = zone;
        this.imaginaryLine = imaginaryLine;
    }

    public String prettyName() {
        return this.prettyName;
    }

    public int regionId() {
        return this.regionId;
    }

    public int zone() {
        return this.zone;
    }

    @Nullable
    public WorldArea imaginaryLine() {
        return this.imaginaryLine;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Region region : Region.values()) {
            builder.put((Object)region.regionId, (Object)region);
        }
        lookupMap = builder.build();
    }
}

