/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.api.game;

import com.tobqol.api.game.Region;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface Instance {
    @Nullable
    public static Mode findFirstMode(Predicate<Mode> filter) {
        if (filter == null) {
            return null;
        }
        for (Mode mode : Mode.values()) {
            if (!filter.test(mode)) continue;
            return mode;
        }
        return null;
    }

    public boolean lazySetMode(Supplier<Mode> var1);

    @Nullable
    public Mode mode();

    public boolean isStoryMode();

    public boolean isRegularMode();

    public boolean isHardMode();

    public Region getCurrentRegion();

    public int getRaidStatus();

    public boolean isInRaid();

    public int getRoomStatus();

    public int getPartyStatus();

    public int getPartySize();

    public int getDeathSize();

    public int getTotalAlive();

    public int getTickCycle();

    public void resetTickCycle();

    public int getBossHealth();

    public static enum Mode {
        STORY,
        REGULAR,
        HARD;


        public boolean isStoryMode() {
            return this == STORY;
        }

        public boolean isRegularMode() {
            return this == REGULAR;
        }

        public boolean isHardMode() {
            return this == HARD;
        }
    }
}

