/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.api.game;

import com.tobqol.api.game.Instance;

public enum Hitpoints {
    MAIDEN(500, 2625, 3062, 3500, 2625, 3062, 3500),
    MAIDEN_MATOMENOS(16, 75, 87, 100, 75, 87, 100),
    MAIDEN_BLOOD_SPAWN(0, 0, 0, 0, 0, 0, 0),
    BLOAT(320, 1500, 1750, 2000, 1800, 2100, 2400),
    NYLOCAS_BOSS(360, 1875, 2187, 2500, 0, 0, 0),
    NYLOCAS_DEMI_BOSS(-1, -1, -1, -1, 0, 0, 0),
    NYLOCAS_SMALL(2, 8, 9, 11, 0, 0, 0),
    NYLOCAS_BIG(3, 16, 19, 22, 0, 0, 0),
    SOTETSEG(560, 3000, 3500, 4000, 3000, 3500, 4000),
    XARPUS(411, 3810, 4445, 5080, 0, 0, 0),
    VERZIK_P1(300, 0, 0, 0, 0, 0, 0),
    VERZIK_P2(400, 2437, 2843, 3250, 0, 0, 0),
    VERZIK_P3(574, 2437, 2843, 3250, 0, 0, 0),
    VERZIK_MATOMENOS(0, 150, 175, 200, 0, 0, 0),
    VERZIK_NYLOCAS(0, 0, 0, 0, 0, 0, 0);

    private final int sm_solo;
    private final int rg_trios;
    private final int rg_fours;
    private final int rg_fives;
    private final int hm_trios;
    private final int hm_fours;
    private final int hm_fives;

    public int getBaseHP(Instance instance) {
        if (instance == null) {
            return 0;
        }
        Instance.Mode mode = instance.mode();
        int partySize = instance.getPartySize();
        if (mode == null || partySize <= 0) {
            return 0;
        }
        if (mode.isStoryMode()) {
            return this.sm_solo * partySize;
        }
        switch (partySize) {
            case 5: {
                return mode.isRegularMode() ? this.rg_fives : this.hm_fives;
            }
            case 4: {
                return mode.isRegularMode() ? this.rg_fours : this.hm_fours;
            }
        }
        return mode.isRegularMode() ? this.rg_trios : this.hm_trios;
    }

    private Hitpoints(int sm_solo, int rg_trios, int rg_fours, int rg_fives, int hm_trios, int hm_fours, int hm_fives) {
        this.sm_solo = sm_solo;
        this.rg_trios = rg_trios;
        this.rg_fours = rg_fours;
        this.rg_fives = rg_fives;
        this.hm_trios = hm_trios;
        this.hm_fours = hm_fours;
        this.hm_fives = hm_fives;
    }
}

