/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.api.game;

import java.awt.Color;
import java.text.DecimalFormat;
import org.apache.commons.lang3.math.NumberUtils;

public class Health
implements Comparable<Health> {
    private final int base;
    private int current;

    public Health(int base) {
        this.base = base;
        this.current = base;
    }

    public boolean zero() {
        return this.current == 0;
    }

    public Health addHealth(int amount) {
        this.current = Math.min(this.current + amount, this.base);
        return this;
    }

    public Health removeHealth(int amount) {
        this.current = Math.max(this.current - amount, 0);
        return this;
    }

    public double percent() {
        return (double)this.current / (double)this.base;
    }

    public double truncatedPercent() {
        return NumberUtils.toDouble((String)new DecimalFormat("#.0").format(this.percent() * 100.0));
    }

    public Color color() {
        double percent = this.percent();
        if (percent > 1.0) {
            percent = 1.0;
        } else if (percent < 0.0) {
            percent = 0.0;
        }
        int r = (int)(255.0 * (1.0 - percent));
        int g = (int)(255.0 * percent);
        return new Color(r, g, 0, 255);
    }

    @Override
    public int compareTo(Health o) {
        return Integer.compare(this.current, o.current);
    }

    public int getBase() {
        return this.base;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }
}

