/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.tobqol.EventManager;
import com.tobqol.InstanceService;
import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLOverlay;
import com.tobqol.api.game.Instance;
import com.tobqol.api.game.RaidConstants;
import com.tobqol.api.game.Region;
import com.tobqol.config.SupplyChestPreference;
import com.tobqol.rooms.RemovableOverlay;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.bloat.BloatHandler;
import com.tobqol.rooms.maiden.MaidenHandler;
import com.tobqol.rooms.nylocas.NylocasHandler;
import com.tobqol.rooms.sotetseg.SotetsegHandler;
import com.tobqol.rooms.verzik.VerzikHandler;
import com.tobqol.rooms.xarpus.XarpusHandler;
import com.tobqol.tracking.RoomDataHandler;
import java.awt.Font;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.ObjectComposition;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB QoL", description="Theatre of Blood Quality of Life Enhancement Features to be used throughout a raid", tags={"tob", "tobqol", "of", "blood", "maiden", "bloat", "nylo", "nylocas", "sotetseg", "xarpus", "verzik", "combat", "bosses", "pvm", "pve", "damen"}, enabledByDefault=true, loadInSafeMode=false)
public class TheatreQOLPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TheatreQOLPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    public OverlayManager overlayManager;
    @Inject
    private EventManager eventManager;
    @Inject
    private InstanceService instanceService;
    @Inject
    private Provider<MaidenHandler> maiden;
    @Inject
    private Provider<BloatHandler> bloat;
    @Inject
    private Provider<NylocasHandler> nylocas;
    @Inject
    private Provider<SotetsegHandler> sotetseg;
    @Inject
    private Provider<XarpusHandler> xarpus;
    @Inject
    private Provider<VerzikHandler> verzik;
    @Inject
    private TheatreQOLOverlay overlay;
    @Inject
    private TheatreQOLConfig config;
    @Inject
    public InfoBoxManager infoBoxManager;
    @CheckForNull
    private RoomHandler[] rooms = null;
    private final Multimap<String, RemovableOverlay> removableOverlays = MultimapBuilder.hashKeys().arrayListValues().build();
    private RoomDataHandler dataHandler;
    private boolean darknessHidden;
    private GameObject entrance;
    private GameObject lootChest;
    boolean chestHasLoot = false;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();
    public Font pluginFont;
    public Font instanceTimerFont;
    public int previousRegion;

    @Provides
    TheatreQOLConfig provideConfig(ConfigManager configManager) {
        return (TheatreQOLConfig)configManager.getConfig(TheatreQOLConfig.class);
    }

    public void configure(Binder binder) {
        binder.bind(Instance.class).to(InstanceService.class);
    }

    protected void startUp() {
        this.dataHandler = new RoomDataHandler(this.client, this, this.config);
        this.dataHandler.load();
        this.buildFont(false);
        this.buildFont(true);
        this.overlayManager.add((Overlay)this.overlay);
        this.eventManager.startUp();
        if (this.rooms == null) {
            for (RoomHandler room : this.rooms = new RoomHandler[]{(RoomHandler)this.maiden.get(), (RoomHandler)this.bloat.get(), (RoomHandler)this.nylocas.get(), (RoomHandler)this.sotetseg.get(), (RoomHandler)this.xarpus.get(), (RoomHandler)this.verzik.get()}) {
                room.init();
            }
        }
        for (RoomHandler room : this.rooms) {
            room.load();
            this.eventBus.register((Object)room);
        }
    }

    protected void shutDown() {
        this.reset(true);
        this.overlayManager.remove((Overlay)this.overlay);
        this.eventManager.shutDown();
        this.removableOverlays.forEach((k, v) -> this.overlayManager.removeIf(v.provideOverlay().getClass()::isInstance));
        this.removableOverlays.clear();
        if (this.rooms != null) {
            for (RoomHandler room : this.rooms) {
                this.eventBus.unregister((Object)room);
                room.unload();
            }
        }
        this.dataHandler.unload();
    }

    void reset(boolean global) {
        this.dataHandler.getData().clear();
        if (this.rooms != null) {
            for (RoomHandler room : this.rooms) {
                room.reset();
                log.debug("Resetting {}", (Object)room.getClass().getSimpleName());
            }
        }
        if (global) {
            this.darknessHidden = false;
            this.hideDarkness(false);
            this.entrance = null;
            this.lootChest = null;
            this.chestHasLoot = false;
            this.client.clearHintArrow();
        }
    }

    public boolean addRemovableOverlay(String configKey, RemovableOverlay removableOverlay) {
        if (Strings.isNullOrEmpty((String)configKey) || removableOverlay == null || this.removableOverlays.containsValue((Object)removableOverlay)) {
            return false;
        }
        if (!removableOverlay.remove(this.config)) {
            this.overlayManager.add(removableOverlay.provideOverlay());
        }
        return this.removableOverlays.put((Object)configKey, (Object)removableOverlay);
    }

    @Subscribe(priority=1.0f)
    private void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("tobqol")) {
            return;
        }
        String key = e.getKey();
        this.removableOverlays.get((Object)key).forEach(removableOverlay -> {
            Overlay overlay = removableOverlay.provideOverlay();
            if (removableOverlay.remove(this.config)) {
                this.overlayManager.removeIf(overlay.getClass()::isInstance);
                return;
            }
            this.overlayManager.add(overlay);
        });
        switch (e.getKey()) {
            case "lightUp": {
                this.hideDarkness(Boolean.valueOf(e.getNewValue()));
            }
            case "lootReminder": {
                if (this.client.hasHintArrow() && !Boolean.valueOf(e.getNewValue()).booleanValue()) {
                    this.client.clearHintArrow();
                }
            }
            case "fontType": 
            case "fontSize": 
            case "fontStyle": {
                this.buildFont(false);
            }
            case "instanceTimerSize": {
                this.buildFont(true);
            }
            case "displayTimeSplits": {
                this.dataHandler.updateHiddenItems(Boolean.valueOf(e.getNewValue()) == false);
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.instanceService.getCurrentRegion() != this.instanceService.getPreviousRegion()) {
            if (this.instanceService.getCurrentRegion().isSotetsegUnderworld() && this.instanceService.getPreviousRegion().isSotetseg() || this.instanceService.getCurrentRegion().isMaiden() && this.instanceService.getPreviousRegion().isUnknown()) {
                return;
            }
            this.dataHandler.getData().clear();
            this.instanceService.setPreviousRegion(this.instanceService.getCurrentRegion());
        }
        if ((this.isInVerSinhaza() && this.config.lightUp() || this.isInSotetseg() && this.config.hideSotetsegWhiteScreen()) && !this.darknessHidden) {
            this.hideDarkness(true);
        } else if (!this.isInVerSinhaza() && !this.isInSotetseg() && this.darknessHidden) {
            this.hideDarkness(false);
        }
        if (this.isInVerSinhaza()) {
            if (this.lootChest != null && Objects.requireNonNull(this.getObjectComposition(this.lootChest.getId())).getId() == 41435 && !this.chestHasLoot) {
                this.chestHasLoot = true;
                if (this.config.lootReminder()) {
                    this.client.setHintArrow(this.lootChest.getWorldLocation());
                }
            }
            if (this.lootChest != null && Objects.requireNonNull(this.getObjectComposition(this.lootChest.getId())).getId() == 41436 && this.chestHasLoot) {
                this.chestHasLoot = false;
                this.client.clearHintArrow();
            }
        } else if (this.lootChest != null) {
            this.lootChest = null;
        }
    }

    @Subscribe
    private void onClientTick(ClientTick e) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (this.config.supplyChestMES() != SupplyChestPreference.OFF) {
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            int index = 0;
            this.optionIndexes.clear();
            for (MenuEntry entry : menuEntries) {
                String option = Text.removeTags((String)entry.getOption());
                this.optionIndexes.put((Object)option, (Object)index++);
            }
            index = 0;
            MenuEntry[] menuEntryArray = menuEntries;
            int n = menuEntryArray.length;
            for (int i = 0; i < n; ++i) {
                MenuEntry entry;
                entry = menuEntryArray[i];
                this.swapMenuEntry(index++, entry);
            }
        }
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.client.isMenuOpen() && this.config.bankAllMES() && (this.isInVerSinhaza() || this.isInLootRoom())) {
            MenuEntry[] entries;
            for (MenuEntry entry : entries = this.client.getMenuEntries()) {
                if (!entry.getOption().equals("Bank-all")) continue;
                entry.setForceLeftClick(true);
                break;
            }
            this.client.setMenuEntries(entries);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        switch (event.getGameObject().getId()) {
            case 41437: {
                this.lootChest = event.getGameObject();
                break;
            }
            case 32653: {
                this.entrance = event.getGameObject();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.HOPPING) {
            this.hideDarkness(false);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.instanceService.isInRaid() && event.getType().equals((Object)ChatMessageType.GAMEMESSAGE) && event.getMessage().contains("You have failed. The vampyres take pity on you and allow you to try again.")) {
            this.reset(false);
        }
    }

    @Nullable
    private ObjectComposition getObjectComposition(int id) {
        ObjectComposition objectComposition = this.client.getObjectDefinition(id);
        return objectComposition.getImpostorIds() == null ? objectComposition : objectComposition.getImpostor();
    }

    protected void hideDarkness(boolean hide) {
        Widget darkness = this.client.getWidget(0x1C0001);
        if (darkness != null) {
            this.darknessHidden = hide;
            darkness.setHidden(hide);
        }
    }

    public boolean isInVerSinhaza() {
        return RaidConstants.VER_SINHAZA_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID());
    }

    public boolean isInSotetseg() {
        LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
        int region = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local).getRegionID();
        return region == Region.SOTETSEG.regionId() || region == Region.SOTETSEG_MAZE.regionId();
    }

    private boolean isInLootRoom() {
        LocalPoint local = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local).getRegionID() == 12867;
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        String option = Text.removeTags((String)menuEntry.getOption());
        String target = Text.removeTags((String)menuEntry.getTarget());
        if (option.equals("Value") && !this.config.supplyChestMES().toString().equals("Value") && RaidConstants.TOB_CHEST_TARGETS.contains(target)) {
            this.swap(option, target, index);
        }
    }

    private void swap(String option, String target, int index) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int thisIndex = this.findIndex(menuEntries, index, option, target);
        int optionIdx = this.findIndex(menuEntries, thisIndex, this.config.supplyChestMES().toString(), target);
        if (thisIndex >= 0 && optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, thisIndex);
        }
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target) {
        List indexes = this.optionIndexes.get((Object)option);
        for (int i = indexes.size() - 1; i >= 0; --i) {
            int index = (Integer)indexes.get(i);
            MenuEntry entry = entries[index];
            String entryTarget = Text.removeTags((String)entry.getTarget());
            if (index > limit || !entryTarget.equals(target)) continue;
            return index;
        }
        return -1;
    }

    private void swap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry = entries[index1];
        entries[index1] = entries[index2];
        entries[index2] = entry;
        this.client.setMenuEntries(entries);
        optionIndexes.clear();
        int idx = 0;
        for (MenuEntry menuEntry : entries) {
            String option = Text.removeTags((String)menuEntry.getOption());
            optionIndexes.put((Object)option, (Object)idx++);
        }
    }

    private Font buildFont(boolean timer) {
        if (timer) {
            this.instanceTimerFont = new Font(this.pluginFont.getName(), this.pluginFont.getStyle(), this.config.instanceTimerSize());
            return this.instanceTimerFont;
        }
        String font = null;
        int style = this.config.fontStyle().getValue();
        switch (this.config.fontType().getName()) {
            case "RS Regular": {
                font = FontManager.getRunescapeFont().getName();
                style = FontManager.getRunescapeFont().getStyle();
                break;
            }
            case "RS Bold": {
                font = FontManager.getRunescapeBoldFont().getName();
                style = FontManager.getRunescapeBoldFont().getStyle();
                break;
            }
            case "RS Small": {
                font = FontManager.getRunescapeSmallFont().getName();
                style = FontManager.getRunescapeSmallFont().getStyle();
            }
        }
        this.pluginFont = new Font(font == null ? this.config.fontStyle().getStyle() : font, style, font == null ? this.config.fontSize() : 16);
        return this.pluginFont;
    }

    public boolean hasSalve() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return false;
        }
        return itemContainer.contains(4081) || itemContainer.contains(10588) || itemContainer.contains(12017) || itemContainer.contains(12018) || itemContainer.contains(25278) || itemContainer.contains(26782) || itemContainer.contains(25250) || itemContainer.contains(26763);
    }

    public String getSpellbook() {
        int spellbookId = this.client.getVarbitValue(4070);
        switch (spellbookId) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Ancient";
            }
            case 2: {
                return "Lunar";
            }
            case 3: {
                return "Arceuus";
            }
        }
        return "n/a";
    }

    public InstanceService getInstanceService() {
        return this.instanceService;
    }

    public RoomDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public GameObject getEntrance() {
        return this.entrance;
    }

    public GameObject getLootChest() {
        return this.lootChest;
    }

    public boolean isChestHasLoot() {
        return this.chestHasLoot;
    }

    public Font getPluginFont() {
        return this.pluginFont;
    }

    public Font getInstanceTimerFont() {
        return this.instanceTimerFont;
    }

    public int getPreviousRegion() {
        return this.previousRegion;
    }
}

