/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol;

import com.google.inject.Inject;
import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheatreQOLOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(TheatreQOLOverlay.class);
    private final TheatreQOLPlugin plugin;
    private final TheatreQOLConfig config;

    @Inject
    private TheatreQOLOverlay(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        Point textLocation;
        Object text;
        graphics.setFont(this.plugin.getPluginFont());
        if (this.config.lootReminder() && this.plugin.isInVerSinhaza() && this.plugin.getLootChest() != null && this.plugin.isChestHasLoot()) {
            Shape poly = this.plugin.getLootChest().getConvexHull();
            if (poly != null) {
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.config.lootReminderColor());
            }
            String text2 = "You have loot in your chest.";
            Point textLocation2 = this.plugin.getEntrance().getCanvasTextLocation(graphics, text2, 0);
            if (textLocation2 != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLocation2.getX(), textLocation2.getY()), (String)text2, (Color)this.config.lootReminderColor());
            }
        }
        if (this.config.salveReminder() && this.plugin.isInVerSinhaza() && !this.plugin.hasSalve()) {
            text = "You have forgotten your salve.";
            textLocation = this.plugin.getEntrance().getCanvasTextLocation(graphics, (String)text, 60);
            if (textLocation != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLocation.getX(), textLocation.getY()), (String)text, (Color)Color.CYAN);
            }
        }
        if (this.config.spellbookReminder() && this.plugin.isInVerSinhaza()) {
            text = "Current Spellbook: " + this.plugin.getSpellbook().toUpperCase();
            textLocation = this.plugin.getEntrance().getCanvasTextLocation(graphics, (String)text, 120);
            if (textLocation != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLocation.getX(), textLocation.getY()), (String)text, (Color)Color.YELLOW);
            }
        }
        return null;
    }
}

