/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol;

import com.tobqol.config.HPDisplayTypes;
import com.tobqol.config.SupplyChestPreference;
import com.tobqol.config.font.FontStyles;
import com.tobqol.config.font.FontTypes;
import com.tobqol.config.times.TimeDisplayType;
import com.tobqol.rooms.nylocas.config.NylocasObjects;
import com.tobqol.rooms.sotetseg.config.SotetsegInstanceTimerTypes;
import com.tobqol.rooms.sotetseg.config.SotetsegProjectileTheme;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="tobqol")
public interface TheatreQOLConfig
extends Config {
    public static final String GROUP_NAME = "tobqol";
    @ConfigSection(name="General", description="Configuration settings for things that are not room-specific", position=1, closedByDefault=true)
    public static final String GENERAL_SECTION = "generalSection";
    @ConfigSection(name="The Maiden of Sugadinti", description="Configuration settings for The Maiden of Sugadinti", position=2, closedByDefault=true)
    public static final String MAIDEN_SECTION = "maidenSection";
    @ConfigSection(name="Pestilent Bloat", description="Configuration settings for Pestilent Bloat", position=3, closedByDefault=true)
    public static final String BLOAT_SECTION = "bloatSection";
    @ConfigSection(name="Nylocas", description="Configuration settings for Nylocas", position=4, closedByDefault=true)
    public static final String NYLO_SECTION = "nyloSection";
    @ConfigSection(name="Sotetseg", description="Configuration settings for Sotetseg", position=5, closedByDefault=true)
    public static final String SOTETSEG_SECTION = "sotetsegSection";
    @ConfigSection(name="Xarpus", description="Configuration settings for Xarpus", position=6, closedByDefault=true)
    public static final String XARPUS_SECTION = "xarpusSection";
    @ConfigSection(name="Verzik Vitur", description="Configuration settings for Verzik Vitur", position=7, closedByDefault=true)
    public static final String VERZIK_SECTION = "verzikSection";
    @ConfigSection(name="Font Settings", description="Configuration settings for the plugin's text overlays", position=8, closedByDefault=true)
    public static final String FONT_SECTION = "fontSection";
    @ConfigSection(name="Time Tracking Settings", description="Configuration settings for the plugin's time tracking features", position=9, closedByDefault=true)
    public static final String TIME_SECTION = "timeSection";

    @ConfigItem(name="Bank-all MES Loot Chest", keyName="bankAllMES", description="- Removes the 'Force Right Click' flag from the [Bank-all] option inside the Monumental Chest in the Loot Room", position=1, section="generalSection")
    default public boolean bankAllMES() {
        return false;
    }

    @ConfigItem(name="Supply Chest MES", keyName="supplyChestMES", description="- Swaps to the preferred purchasing quantity within the supply chests<br>~ Credit - gh: WLoumakis", position=2, section="generalSection")
    default public SupplyChestPreference supplyChestMES() {
        return SupplyChestPreference.OFF;
    }

    @ConfigItem(name="Light Up Ver Sinhaza", keyName="lightUp", description="- Removes the darkness lighting within Ver Sinhaza (ToB Bank Area)<br>~ Credit - gh: Broooklyn", position=3, section="generalSection")
    default public boolean lightUp() {
        return false;
    }

    @ConfigItem(name="Loot Reminder", keyName="lootReminder", description="- Indicates whether or not the chest has loot in it by highlighting the chest and putting a message on the entrance<br>~ Credit - gh: BickusDiggus", position=4, section="generalSection")
    default public boolean lootReminder() {
        return false;
    }

    @ConfigItem(name="Loot Reminder Color", keyName="lootReminderColor", description="- Set a color for the Loot Reminder overlay<br>~ Credit - gh: BickusDiggus", position=5, section="generalSection")
    @Alpha
    default public Color lootReminderColor() {
        return new Color(196, 89, 89, 200);
    }

    @ConfigItem(name="Salve Reminder", keyName="salveReminder", description="- Indicates whether or not you have salve in your inventory prior to entering the raid and putting a message on the entrance<br>", position=6, section="generalSection")
    default public boolean salveReminder() {
        return true;
    }

    @ConfigItem(name="Salve Reminder Color", keyName="salveReminderColor", description="- Set a color for the Salve Reminder overlay<br>", position=7, section="generalSection")
    @Alpha
    default public Color salveReminderColor() {
        return Color.CYAN;
    }

    @ConfigItem(name="Spellbook Reminder", keyName="spellbookReminder", description="- Indicates what spellbook you are on by putting a message on the entrance<br>", position=8, section="generalSection")
    default public boolean spellbookReminder() {
        return true;
    }

    @ConfigItem(name="Spellbook Reminder Color", keyName="spellbookReminderColor", description="- Set a color for the Spellbook Reminder overlay<br>", position=9, section="generalSection")
    @Alpha
    default public Color spellbookReminderColor() {
        return Color.YELLOW;
    }

    @ConfigItem(name="Display Crabs Health", keyName="maidenCrabHPDisplayType", description="- Displays the hitpoints percentage or the hitpoints of each alive Nylocas Matomenos", position=1, section="maidenSection")
    default public HPDisplayTypes getMaidenCrabHPType() {
        return HPDisplayTypes.OFF;
    }

    @ConfigItem(name="Show Leaks", keyName="maidenLeaks", description="- Sends a client message per leak showing what leaked, their hp and on what Maiden phase", position=2, section="maidenSection")
    default public boolean displayMaidenLeaks() {
        return false;
    }

    @ConfigItem(name="Hide Ceiling Chains", keyName="hideCeilingChains", description="- Hides the chains hanging from the ceiling in the Bloat room<br>* Disabling this feature whilst in Bloat will cause a stutter to refresh the scene", position=1, section="bloatSection")
    default public boolean shouldNullCeilingChains() {
        return false;
    }

    @ConfigItem(name="Track Downs in Chat/Infobox", keyName="trackDowns", description="- Track the Bloat downs in chat/tooltip after room completion<br>* Must have the Chat/Infobox Data Tracking enabled", position=2, section="bloatSection")
    default public boolean trackDowns() {
        return false;
    }

    @ConfigItem(name="Pillar HP", keyName="nyloPillarHP", description="- Display the health of each pillar", position=1, section="nyloSection")
    default public boolean showNylocasPillarHP() {
        return false;
    }

    @ConfigItem(name="Hide Objects", keyName="nyloHideObjects", description="- Hide the Nylocas Pillars, Spectator Webs, and/or Walls if desired (none provide clickboxes when present)<br>* Disabling this feature whilst in the Nylocas room will cause a stutter to refresh the scene", position=2, section="nyloSection")
    default public NylocasObjects nyloHideObjects() {
        return NylocasObjects.OFF;
    }

    @ConfigItem(name="Recolor Menu", keyName="nyloWavesRecolorMenu", description="- Recolors each entry in the menu to their respective color<br>* Gray: Melee (Nylocas Ischyros)<br>* Green: Range (Nylocas Toxobolos)<br>* Blue: Magic (Nylocas Hagios)", position=3, section="nyloSection")
    default public boolean nyloWavesRecolorMenu() {
        return false;
    }

    @ConfigItem(name="Recolor Bigs Menu Darker", keyName="nyloWavesRecolorBigsMenuDarker", description="- Darkens the color on the menu if the Nylocas is big", position=4, section="nyloSection")
    default public boolean nyloWavesRecolorBigsMenuDarker() {
        return false;
    }

    @ConfigItem(name="Role Selector", keyName="displayNyloRoleSelector", description="- Shows the Nylocas Room Role Selection Overlay that you can use to highlight the tiles of your role's nylos", position=5, section="nyloSection")
    default public boolean displayNyloRoleSelector() {
        return false;
    }

    @ConfigItem(name="", keyName="nyloRoleSelectedMage", description="", hidden=true)
    default public boolean nyloRoleSelectedMage() {
        return false;
    }

    @ConfigItem(name="", keyName="nyloRoleSelectedMage", description="", hidden=true)
    public void nyloSetRoleSelectedMage(boolean var1);

    @ConfigItem(name="", keyName="nyloRoleSelectedMelee", description="", hidden=true)
    default public boolean nyloRoleSelectedMelee() {
        return false;
    }

    @ConfigItem(name="", keyName="nyloRoleSelectedMelee", description="", hidden=true)
    public void nyloSetRoleSelectedMelee(boolean var1);

    @ConfigItem(name="", keyName="nyloRoleSelectedRange", description="", hidden=true)
    default public boolean nyloRoleSelectedRange() {
        return false;
    }

    @ConfigItem(name="", keyName="nyloRoleSelectedRange", description="", hidden=true)
    public void nyloSetRoleSelectedRange(boolean var1);

    @ConfigItem(name="Bigs SW Tile", keyName="nyloWavesBigsSWTile", description="- Display the SW Tile of big nylos", position=6, section="nyloSection")
    default public boolean nyloWavesBigsSWTile() {
        return false;
    }

    @ConfigItem(name="Instance Timer", keyName="nyloInstanceTimer", description="- Displays the tick cycle for Nylocas' instance", position=7, section="nyloSection")
    default public boolean nyloInstanceTimer() {
        return false;
    }

    @ConfigItem(name="Low Detail", keyName="nyloLowDetail", description="- Removes the Graphics Objects that spawn when a Nylo dies<br>* Entity hider removes them from being displayed, but still allows them to spawn and linger", position=8, section="nyloSection")
    default public boolean nyloLowDetail() {
        return false;
    }

    @ConfigItem(name="Instance Timer", keyName="sotetsegInstanceTimer", description="- Displays the tick cycle for Sotetsegs' instance<br>* Pre-Start: Displays before the room starts<br>* Maze: Displays during the maze", position=1, section="sotetsegSection")
    default public SotetsegInstanceTimerTypes getSotetsegInstanceTimerType() {
        return SotetsegInstanceTimerTypes.OFF;
    }

    @ConfigItem(name="Projectile Theme", keyName="getSotetsegProjectileTheme", description="- Modifies the Projectile to appear in a specific theme to assist with colorblind users<br>* Inferno: Utilizes the blob mage and range projectiles<br>* TOA: Utilizes the red skull and rock projectiles from Wardens", position=2, section="sotetsegSection")
    default public SotetsegProjectileTheme getSotetsegProjectileTheme() {
        return SotetsegProjectileTheme.DEFAULT;
    }

    @ConfigItem(name="Themed Death Ball", keyName="themedDeathBall", description="- Use the theme's ball to replace Sotetseg's death ball when a theme is selected", position=3, section="sotetsegSection")
    default public boolean themedDeathBall() {
        return true;
    }

    @ConfigItem(name="Hide White Screen", keyName="sotetsegHideWhiteScreen", description="- Hides the transitional white screen during Sotetseg maze phase procs.", position=4, section="sotetsegSection")
    default public boolean hideSotetsegWhiteScreen() {
        return false;
    }

    @ConfigItem(name="Show Chosen Text", keyName="showSotetsegChosenText", description="- Displays a simulated version of 'You have been chosen.' text when Hide White Screen is enabled", position=5, section="sotetsegSection")
    default public boolean showSotetsegChosenText() {
        return true;
    }

    @Range(min=-50, max=50)
    @ConfigItem(name="Chosen Text Offset", keyName="sotetsegChosenTextOffset", description="- Adjusts the height of 'You have been chosen.' text\nwhen Show Chosen Text AND Hide White Screen options are enabled", position=6, section="sotetsegSection")
    default public int sotetsegChosenTextOffset() {
        return 0;
    }

    @ConfigItem(name="Debug Chosen Text", keyName="debugSotetsegChosenText", description="- Displays a simulated version of 'You have been chosen.' text to see height of text", position=7, section="sotetsegSection")
    default public boolean debugSotetsegChosenText() {
        return false;
    }

    @ConfigItem(name="Hide Underworld Rocks", keyName="sotetsegHideUnderworldRocks", description="- Hides the rocks surrounding the Sotetseg maze", position=8, section="sotetsegSection")
    default public boolean sotetsegHideUnderworldRocks() {
        return false;
    }

    @ConfigItem(name="Sotetseg Death Ball Alarm", keyName="sotetsegSoundClip", description="- Replaces the Death Ball sound effect with a wee-woo sound clip<br>* Thank you Hoyaa for providing this sound clip for the project", position=9, section="sotetsegSection")
    default public boolean sotetsegSoundClip() {
        return false;
    }

    @Range(max=100)
    @ConfigItem(name="Death Ball Alarm Volume", keyName="sotetsegSoundClipVolume", description="- Sets the volume of the sound clip", position=10, section="sotetsegSection")
    default public int sotetsegSoundClipVolume() {
        return 65;
    }

    @ConfigItem(name="Instance Timer", keyName="xarpusInstanceTimer", description="- Displays Xarpus's tick cycle for the initial exhumed spawn. Enter on 0 to start exhumeds as soon as possible.", position=1, section="xarpusSection")
    default public boolean displayXarpusInstanceTimer() {
        return false;
    }

    @ConfigItem(name="Mute Xarpus HM Entry", keyName="muteXarpusHMEntry", description="- Mutes the Xarpus hardmode entrance noise when poison splats are thrown", position=2, section="xarpusSection")
    default public boolean muteXarpusHMEntry() {
        return false;
    }

    @ConfigItem(name="Xarpus Sheesh Screech", keyName="xarpusSoundClip", description="- Replaces the Screech sound effect with a Sheesh sound clip<br>~ Credit - Boris<br>* Thank you Hoyaa for providing this sound clip for the project", position=3, section="xarpusSection")
    default public boolean xarpusSoundClip() {
        return false;
    }

    @Range(max=100)
    @ConfigItem(name="Sheesh Volume", keyName="xarpusSoundClipVolume", description="- Sets the volume of the sound clip", position=4, section="xarpusSection")
    default public int xarpusSoundClipVolume() {
        return 65;
    }

    @ConfigItem(name="Verzik Reds Health Overlay", keyName="verzikReds", description="- Displays the health of red crabs during Verzik", position=1, section="verzikSection")
    default public boolean verzikReds() {
        return false;
    }

    @ConfigItem(name="Mark Tornadoes", keyName="verzikTornadoes", description="- Highlight Verzik tornadoes", position=2, section="verzikSection")
    default public boolean shouldMarkVerzikTornadoes() {
        return false;
    }

    @ConfigItem(name="Marked Tornado Color", keyName="verzikMarkedTornadoColor", description="- Set the color of the marked tornadoes overlay", position=3, section="verzikSection")
    @Alpha
    default public Color verzikMarkedTornadoColor() {
        return new Color(215, 122, 97);
    }

    @ConfigItem(name="Mute Verzik Sounds", keyName="muteVerzikSounds", description="- Mute Verzik's sounds such as P2 area affect and her walking in P3", position=4, section="verzikSection")
    default public boolean muteVerzikSounds() {
        return false;
    }

    @ConfigItem(name="Verzik Death Ball Alarm", keyName="verzikSoundClip", description="- Notifies you of the green ball with a wee-woo sound clip on chat message received<br>* Thank you Hoyaa for providing this sound clip for the project", position=5, section="verzikSection")
    default public boolean verzikSoundClip() {
        return false;
    }

    @Range(max=100)
    @ConfigItem(name="Death Ball Alarm Volume", keyName="verzikSoundClipVolume", description="- Sets the volume of the sound clip", position=6, section="verzikSection")
    default public int verzikSoundClipVolume() {
        return 65;
    }

    @ConfigItem(name="Font Type", keyName="fontType", description="Dynamically change the font for all ToB QoL Overlays", position=1, section="fontSection")
    default public FontTypes fontType() {
        return FontTypes.REGULAR;
    }

    @ConfigItem(name="Font Style", keyName="fontStyle", description="Dynamically change the font style for all ToB QoL Overlays<br>* This will not alter the base RS font styles", position=2, section="fontSection")
    default public FontStyles fontStyle() {
        return FontStyles.PLAIN;
    }

    @Range(min=12, max=20)
    @ConfigItem(name="Font Size", keyName="fontSize", description="Dynamically change the font size for all ToB QoL Overlays<br>* This will not alter the base RS font styles", position=3, section="fontSection")
    default public int fontSize() {
        return 16;
    }

    @Range(min=12, max=42)
    @ConfigItem(name="Instance Timer Size", keyName="instanceTimerSize", description="Dynamically change the font size for all the Instance Timers<br>* This inherits the font type and style selected above<br>* This will not alter the base RS font styles", position=3, section="fontSection")
    default public int instanceTimerSize() {
        return 16;
    }

    @Range(min=-12, max=12)
    @ConfigItem(name="Instance Timer Offset", keyName="instanceTimerOffset", description="Dynamically change the vertical offset for all the Instance Timers displayed over a character", position=4, section="fontSection")
    default public int instanceTimerOffset() {
        return 0;
    }

    @ConfigItem(name="Display Room Times", keyName="displayRoomTimes", description="- Display live time for each room's boss<br>* Please note that this will not show splits on rooms that reveal mechanics until the room has ended (Bloat downs)", position=1, section="timeSection")
    default public TimeDisplayType displayRoomTimes() {
        return TimeDisplayType.OFF;
    }

    @ConfigItem(name="Display Splits", keyName="displayTimeSplits", description="- Displays the splits in the room where tracked<br>- Example: [50s - 1:02.4]", position=2, section="timeSection")
    default public boolean displayTimeSplits() {
        return true;
    }

    @ConfigItem(name="Display Split Differences", keyName="displayTimeSplitDifferences", description="- Displays the difference in time between each split<br>- Example: [50s - 1:02.4 (0:24.6)]", position=3, section="timeSection")
    default public boolean displayTimeSplitDifferences() {
        return false;
    }

    @ConfigItem(name="Validate Room Completion", keyName="roomTimeValidation", description="- Displays the room completion time that the plugin tracks independently to validate plugin timing", position=4, section="timeSection")
    default public boolean roomTimeValidation() {
        return false;
    }

    @ConfigItem(name="Shrunk Live Timer Size", keyName="shrunkLiveTimerDesign", description="- Live timer overlay with Plain San Serif at a font size of 11 to minimize the overlay size<br>Note: You can use RuneLite's overlay settings in Core 'RuneLite' Settings to configure the overlay", position=5, section="timeSection")
    default public boolean shrunkLiveTimerDesign() {
        return false;
    }
}

