/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol;

import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Instance;
import com.tobqol.api.game.Region;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class InstanceService
implements Instance {
    private static final Logger log = LoggerFactory.getLogger(InstanceService.class);
    private final Client client;
    private final TheatreQOLPlugin plugin;
    private int partyStatus = 0;
    private int roomStatus = 0;
    private int bossHealth = -1;
    private boolean preciseTimers = false;
    private Instance.Mode mode = null;
    private Region region = Region.UNKNOWN;
    private final Set<String> raiders = new HashSet<String>();
    private final Set<String> deadRaiders = new HashSet<String>();
    private boolean regionUpdated = false;
    private int tickCycle = -1;
    private Region previousRegion;

    @Inject
    InstanceService(Client client, TheatreQOLPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
    }

    void reset() {
        this.region = Region.UNKNOWN;
        this.mode = null;
        this.regionUpdated = false;
        this.tickCycle = -1;
        this.deadRaiders.clear();
        this.raiders.clear();
        this.bossHealth = -1;
    }

    void tick() {
        if (this.regionUpdated && this.roomStatus == 0) {
            if (this.region.isLobby() || this.region.isLootRoom() || this.region.isUnknown()) {
                this.regionUpdated = false;
                this.tickCycle = -1;
                return;
            }
            for (Player player : this.client.getPlayers()) {
                if (!this.region.isPCIL(this.client, player)) continue;
                log.debug("Updating Theatre of Blood instance timer for '{}'. Previous: {}, New: [2b, 3a]", (Object)this.region.next().prettyName(), (Object)this.tickCycle);
                this.regionUpdated = false;
                this.tickCycle = 2;
                break;
            }
        }
        if (this.tickCycle == -1) {
            return;
        }
        ++this.tickCycle;
        this.tickCycle %= 4;
    }

    boolean outside() {
        return this.partyStatus <= 1;
    }

    boolean limbo() {
        return this.outside() || this.roomStatus == 0;
    }

    void setPartyStatus(int value) {
        if (this.partyStatus == value) {
            return;
        }
        this.partyStatus = value;
        if (this.outside()) {
            this.reset();
            this.plugin.reset(false);
        }
    }

    void setRoomStatus(int value) {
        if (this.roomStatus == value) {
            return;
        }
        this.roomStatus = value;
        if (value == 0) {
            this.deadRaiders.clear();
        }
    }

    void setRegion(Region region) {
        if (region == null) {
            return;
        }
        if (this.region.isSotetseg() && !region.isSotetseg() || this.region != region) {
            this.regionUpdated = true;
        }
        this.region = region;
    }

    void addRaider(String name) {
        if (this.raiders.contains(name)) {
            return;
        }
        this.raiders.add(name);
    }

    void addDeadRaider(String name) {
        if (this.deadRaiders.contains(name)) {
            return;
        }
        this.deadRaiders.add(name);
    }

    @Override
    public boolean lazySetMode(Supplier<Instance.Mode> modeSupplier) {
        if (this.mode != null || modeSupplier == null) {
            return false;
        }
        Instance.Mode nMode = modeSupplier.get();
        if (nMode == null || Objects.equals((Object)this.mode, (Object)nMode)) {
            return false;
        }
        log.debug("Setting Theatre of Blood instanced-mode. Previous: {}, New: {}", this.mode == null ? "UNKNOWN" : this.mode, (Object)nMode);
        this.mode = nMode;
        return true;
    }

    @Override
    public boolean isInRaid() {
        return this.partyStatus == 2 || this.partyStatus == 3;
    }

    @Override
    @Nullable
    public Instance.Mode mode() {
        return this.mode;
    }

    @Override
    public boolean isStoryMode() {
        return this.mode != null && this.mode.isStoryMode();
    }

    @Override
    public boolean isRegularMode() {
        return this.mode != null && this.mode.isRegularMode();
    }

    @Override
    public boolean isHardMode() {
        return this.mode != null && this.mode.isHardMode();
    }

    @Override
    public Region getCurrentRegion() {
        return this.region;
    }

    @Override
    public int getRaidStatus() {
        return this.partyStatus;
    }

    @Override
    public int getRoomStatus() {
        return this.roomStatus;
    }

    @Override
    public int getPartyStatus() {
        return this.partyStatus;
    }

    @Override
    public int getPartySize() {
        return this.raiders.size();
    }

    @Override
    public int getDeathSize() {
        return this.deadRaiders.size();
    }

    @Override
    public int getTotalAlive() {
        return Math.max(this.getPartySize() - this.getDeathSize(), 0);
    }

    @Override
    public int getTickCycle() {
        return this.tickCycle;
    }

    @Override
    public void resetTickCycle() {
        this.tickCycle = -1;
    }

    @Override
    public int getBossHealth() {
        return this.bossHealth;
    }

    public void setBossHealth(int bossHealth) {
        this.bossHealth = bossHealth;
    }

    public void setPreciseTimers(boolean preciseTimers) {
        this.preciseTimers = preciseTimers;
    }

    public Region getPreviousRegion() {
        return this.previousRegion;
    }

    public void setPreviousRegion(Region previousRegion) {
        this.previousRegion = previousRegion;
    }
}

