/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol;

import com.google.common.base.Strings;
import com.tobqol.InstanceService;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
final class EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private final Client client;
    private final EventBus eventBus;
    private final TheatreQOLPlugin plugin;
    private final InstanceService instance;

    @Inject
    EventManager(Client client, EventBus eventBus, TheatreQOLPlugin plugin, InstanceService instance) {
        this.client = client;
        this.eventBus = eventBus;
        this.plugin = plugin;
        this.instance = instance;
    }

    void startUp() {
        this.instance.reset();
        this.eventBus.register((Object)this);
    }

    void shutDown() {
        this.eventBus.unregister((Object)this);
        this.instance.reset();
    }

    private void reset(boolean global) {
        this.plugin.reset(global);
        this.instance.reset();
    }

    @Subscribe(priority=7.0f)
    private void onGameStateChanged(GameStateChanged gsc) {
        GameState gs = gsc.getGameState();
        if (gs.equals((Object)GameState.LOGGED_IN) || gs.equals((Object)GameState.LOGIN_SCREEN)) {
            if (gs.equals((Object)GameState.LOGIN_SCREEN)) {
                this.reset(true);
                return;
            }
            boolean inside = false;
            for (Region r : Region.values()) {
                if (r.isLobby() || r.isUnknown() || !Region.inRegion(this.client, r)) continue;
                inside = true;
                this.instance.setRegion(r);
                break;
            }
            if (!inside) {
                this.reset(false);
            }
        }
    }

    @Subscribe(priority=7.0f)
    private void onVarbitChanged(VarbitChanged e) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        this.instance.setPartyStatus(this.client.getVarbitValue(6440));
        this.instance.setRoomStatus(this.client.getVarbitValue(6447));
        this.instance.setBossHealth(this.client.getVarbitValue(6448));
        this.instance.setPreciseTimers(this.client.getVarbitValue(11866) == 1);
    }

    @Subscribe(priority=7.0f)
    private void onGameTick(GameTick e) {
        if (this.instance.outside()) {
            return;
        }
        block4: for (int varcStrId = 330; varcStrId <= 334; ++varcStrId) {
            String username = Text.standardize((String)this.client.getVarcStrValue(varcStrId));
            if (Strings.isNullOrEmpty((String)username)) continue;
            switch (this.client.getVarbitValue(6442 + varcStrId % 5)) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    this.instance.addRaider(username);
                    this.instance.addDeadRaider(username);
                    continue block4;
                }
                default: {
                    this.instance.addRaider(username);
                }
            }
        }
        this.instance.tick();
    }
}

