/*
 * Decompiled with CFR 0.152.
 */
package com.CosRoom;

import com.CosRoom.CosRoomConfig;
import com.CosRoom.CosRoomPlugin;
import com.CosRoom.items.ArmorCase;
import com.CosRoom.items.CapeRack;
import com.CosRoom.items.FancyDressBox;
import com.CosRoom.items.MagicWardrobe;
import com.CosRoom.items.ToyBox;
import com.CosRoom.items.TreasureChest;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class CostumeHighlightOverlay
extends WidgetItemOverlay {
    private final ItemManager itemMan;
    private final CosRoomConfig config;
    private final ToyBox toyBox;
    private final ArmorCase armorCase;
    private final CapeRack capeRack;
    private final FancyDressBox fancyDressBox;
    private final MagicWardrobe magicWardrobe;
    private final TreasureChest treasureChest;

    @Inject
    private CostumeHighlightOverlay(ItemManager itemMan, CosRoomPlugin plugin, CosRoomConfig config) {
        this.config = config;
        this.itemMan = itemMan;
        this.toyBox = new ToyBox();
        this.armorCase = new ArmorCase();
        this.capeRack = new CapeRack();
        this.fancyDressBox = new FancyDressBox();
        this.magicWardrobe = new MagicWardrobe();
        this.treasureChest = new TreasureChest();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemID, WidgetItem itemWidget) {
        Color highlightColor = this.config.getHouseColor();
        if (this.checkStorability(itemID)) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            BufferedImage outline = this.itemMan.getItemOutline(itemID, itemWidget.getQuantity(), highlightColor);
            graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
        }
    }

    private boolean checkStorability(int itemID) {
        if (this.config.toyBoxEnabled() && this.toyBox.checkList(itemID)) {
            return true;
        }
        if (this.config.armorCaseEnabled() && this.armorCase.checkList(itemID)) {
            return true;
        }
        if (this.config.CapeRackEnabled() && this.capeRack.checkList(itemID)) {
            return true;
        }
        if (this.config.FancyDressBoxEnabled() && this.fancyDressBox.checkList(itemID)) {
            return true;
        }
        if (this.config.MagicWardrobeEnabled() && this.magicWardrobe.checkList(itemID)) {
            return true;
        }
        return this.config.TreasureChestEnabled() && this.treasureChest.checkList(itemID);
    }
}

