/*
 * Decompiled with CFR 0.152.
 */
package com.tabsviewer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;

public class EquipmentViewerOverlay
extends OverlayPanel {
    private static final int PLACEHOLDER_WIDTH = 36;
    private static final int PLACEHOLDER_WIDTH_150_PERCENT = 57;
    private static final int PLACEHOLDER_HEIGHT = 32;
    private static final ImageComponent PLACEHOLDER_IMAGE = new ImageComponent(new BufferedImage(36, 32, 6));
    private final ItemManager itemManager;
    private final Client client;

    @Inject
    private EquipmentViewerOverlay(Client client, ItemManager itemManager) {
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.panelComponent.setWrap(true);
        this.panelComponent.setGap(new Point(6, 4));
        this.panelComponent.setPreferredSize(new Dimension(168, 0));
        this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.itemManager = itemManager;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return null;
        }
        Item[] items = itemContainer.getItems();
        ArrayList<ArrayList<Item>> loop = this.getEquipment(items);
        this.panelComponent.getChildren().clear();
        this.buildFirstRow(loop.get(0));
        this.buildSecondRow(loop.get(1));
        this.buildThirdRow(loop.get(2));
        this.buildForthRow(loop.get(3));
        this.buildFifthRow(loop.get(4));
        return this.panelComponent.render(graphics);
    }

    private void buildFirstRow(ArrayList<Item> row) {
        for (int j = 0; j < row.size(); ++j) {
            if (j == 0) {
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(57, 32, 6)));
                continue;
            }
            if (j == 2) {
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(57, 32, 6)));
                continue;
            }
            Item item = row.get(j);
            if (item != null && item.getQuantity() > 0) {
                BufferedImage image = this.getImage(item);
                if (image == null) continue;
                this.panelComponent.getChildren().add(new ImageComponent(image));
                continue;
            }
            this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
        }
    }

    private void buildSecondRow(ArrayList<Item> row) {
        for (int j = 0; j < row.size(); ++j) {
            BufferedImage image;
            Item item;
            if (j == 0) {
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(15, 32, 6)));
                item = row.get(j);
                if (item != null && item.getQuantity() > 0) {
                    image = this.getImage(item);
                    if (image == null) continue;
                    this.panelComponent.getChildren().add(new ImageComponent(image));
                    continue;
                }
                this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
                continue;
            }
            if (j == 1) {
                item = row.get(j);
                if (item != null && item.getQuantity() > 0) {
                    image = this.getImage(item);
                    if (image == null) continue;
                    this.panelComponent.getChildren().add(new ImageComponent(image));
                    continue;
                }
                this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
                continue;
            }
            if (j != 2) continue;
            item = row.get(j);
            if (item != null && item.getQuantity() > 0) {
                image = this.getImage(item);
                if (image == null) continue;
                this.panelComponent.getChildren().add(new ImageComponent(image));
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(15, 32, 6)));
                continue;
            }
            this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(15, 32, 6)));
            this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
        }
    }

    private void buildThirdRow(ArrayList<Item> row) {
        for (int j = 0; j < row.size(); ++j) {
            BufferedImage image;
            Item item;
            if (j == 0) {
                item = row.get(j);
                if (item != null && item.getQuantity() > 0) {
                    image = this.getImage(item);
                    if (image == null) continue;
                    this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(3, 32, 6)));
                    this.panelComponent.getChildren().add(new ImageComponent(image));
                    continue;
                }
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(3, 32, 6)));
                this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
                continue;
            }
            if (j == 1) {
                item = row.get(j);
                if (item != null && item.getQuantity() > 0) {
                    image = this.getImage(item);
                    if (image == null) continue;
                    this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(4, 32, 6)));
                    this.panelComponent.getChildren().add(new ImageComponent(image));
                    continue;
                }
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(4, 32, 6)));
                this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
                continue;
            }
            if (j != 2) continue;
            item = row.get(j);
            if (item != null && item.getQuantity() > 0) {
                image = this.getImage(item);
                if (image == null) continue;
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(2, 32, 6)));
                this.panelComponent.getChildren().add(new ImageComponent(image));
                continue;
            }
            this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
        }
    }

    private void buildForthRow(ArrayList<Item> row) {
        for (int j = 0; j < row.size(); ++j) {
            if (j == 0) {
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(9, 32, 6)));
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(57, 32, 6)));
                continue;
            }
            if (j == 2) {
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(57, 32, 6)));
                continue;
            }
            Item item = row.get(j);
            if (item != null && item.getQuantity() > 0) {
                BufferedImage image = this.getImage(item);
                if (image == null) continue;
                this.panelComponent.getChildren().add(new ImageComponent(image));
                continue;
            }
            this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
        }
    }

    private void buildFifthRow(ArrayList<Item> row) {
        for (int j = 0; j < row.size(); ++j) {
            BufferedImage image;
            Item item;
            if (j == 0) {
                item = row.get(j);
                if (item != null && item.getQuantity() > 0) {
                    image = this.getImage(item);
                    if (image == null) continue;
                    this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(3, 32, 6)));
                    this.panelComponent.getChildren().add(new ImageComponent(image));
                    continue;
                }
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(3, 32, 6)));
                this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
                continue;
            }
            if (j == 1) {
                item = row.get(j);
                if (item != null && item.getQuantity() > 0) {
                    image = this.getImage(item);
                    if (image == null) continue;
                    this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(2, 32, 6)));
                    this.panelComponent.getChildren().add(new ImageComponent(image));
                    continue;
                }
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(2, 32, 6)));
                this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
                continue;
            }
            if (j != 2) continue;
            item = row.get(j);
            if (item != null && item.getQuantity() > 0) {
                image = this.getImage(item);
                if (image == null) continue;
                this.panelComponent.getChildren().add(new ImageComponent(new BufferedImage(2, 32, 6)));
                this.panelComponent.getChildren().add(new ImageComponent(image));
                continue;
            }
            this.panelComponent.getChildren().add(PLACEHOLDER_IMAGE);
        }
    }

    private ArrayList<ArrayList<Item>> getEquipment(Item[] items) {
        ArrayList<Item> row1 = new ArrayList<Item>();
        this.addItemIfExists(row1, items, -1);
        this.addItemIfExists(row1, items, 0);
        this.addItemIfExists(row1, items, -1);
        ArrayList<Item> row2 = new ArrayList<Item>();
        this.addItemIfExists(row2, items, 1);
        this.addItemIfExists(row2, items, 2);
        this.addItemIfExists(row2, items, 13);
        ArrayList<Item> row3 = new ArrayList<Item>();
        this.addItemIfExists(row3, items, 3);
        this.addItemIfExists(row3, items, 4);
        this.addItemIfExists(row3, items, 5);
        ArrayList<Item> row4 = new ArrayList<Item>();
        this.addItemIfExists(row4, items, 6);
        this.addItemIfExists(row4, items, 7);
        this.addItemIfExists(row4, items, 8);
        ArrayList<Item> row5 = new ArrayList<Item>();
        this.addItemIfExists(row5, items, 9);
        this.addItemIfExists(row5, items, 10);
        this.addItemIfExists(row5, items, 12);
        ArrayList<ArrayList<Item>> returnThis = new ArrayList<ArrayList<Item>>();
        returnThis.add(row1);
        returnThis.add(row2);
        returnThis.add(row3);
        returnThis.add(row4);
        returnThis.add(row5);
        return returnThis;
    }

    private void addItemIfExists(ArrayList<Item> row, Item[] items, int index) {
        if (index == -1) {
            row.add(null);
        } else if (index >= items.length) {
            row.add(null);
        } else {
            row.add(items[index]);
        }
    }

    private BufferedImage getImage(Item item) {
        return this.itemManager.getImage(item.getId(), item.getQuantity(), item.getQuantity() > 1);
    }
}

