/*
 * Decompiled with CFR 0.152.
 */
package com.github.kinztech.npcspawns;

import com.github.kinztech.npcspawns.NpcSpawn;
import com.github.kinztech.npcspawns.NpcSpawnsButton;
import com.github.kinztech.npcspawns.NpcSpawnsOverlay;
import com.github.kinztech.npcspawns.NpcSpawnsPanel;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JButton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.RuneLite;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Npc Spawns")
public class NpcSpawnsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcSpawnsPlugin.class);
    public static final File SPAWNS_DIR = new File(RuneLite.RUNELITE_DIR, "spawns");
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NpcSpawnsOverlay NPCSpawnsOverlay;
    private NpcSpawnsButton enabled;
    private JButton saveSpawns;
    private JButton loadSpawns;
    private JButton clearSpawns;
    private NavigationButton navButton;
    private Map<Integer, NpcSpawn> spawns = new HashMap<Integer, NpcSpawn>();
    private int updatedThisTick = 0;

    protected void startUp() throws Exception {
        if (!SPAWNS_DIR.exists()) {
            SPAWNS_DIR.mkdirs();
        }
        this.enabled = new NpcSpawnsButton("Enabled");
        this.saveSpawns = new JButton("Save Spawns");
        this.saveSpawns.addActionListener(e -> {
            try {
                Path spawnsPath = Paths.get(SPAWNS_DIR.getPath() + "/npc_spawns.json", new String[0]);
                Files.write(spawnsPath, new Gson().toJson(this.spawns.values()).getBytes(), new OpenOption[0]);
                int points = this.spawns.values().stream().mapToInt(value -> value.getPoints().size()).sum();
                System.out.println("Saved " + this.spawns.size() + " spawns with " + points + " points to " + spawnsPath + ".");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.loadSpawns = new JButton("Load Spawns");
        this.loadSpawns.addActionListener(e -> {
            try {
                List tempSpawns = (List)new Gson().fromJson((Reader)new InputStreamReader(new FileInputStream(SPAWNS_DIR.getPath() + "/npc_spawns.json")), new TypeToken<List<NpcSpawn>>(){}.getType());
                int points = 0;
                this.spawns.clear();
                for (NpcSpawn spawn : tempSpawns) {
                    points += spawn.getPoints().size();
                    this.spawns.put(spawn.getIndex(), spawn);
                }
                System.out.println("Loaded " + this.spawns.size() + " spawns with " + points + " points.");
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        });
        this.clearSpawns = new JButton("Clear Spawns");
        this.clearSpawns.addActionListener(e -> this.spawns.clear());
        NpcSpawnsPanel panel = (NpcSpawnsPanel)((Object)this.injector.getInstance(NpcSpawnsPanel.class));
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"npcspawns_icon.png");
        this.overlayManager.add((Overlay)this.NPCSpawnsOverlay);
        this.navButton = NavigationButton.builder().tooltip("Npc Spawns").icon(icon).priority(1).panel((PluginPanel)panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.NPCSpawnsOverlay);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.enabled.isActive()) {
            return;
        }
        NPC npc = event.getNpc();
        NPCComposition def = this.client.getNpcDefinition(event.getNpc().getId());
        NpcSpawn existSpawn = this.spawns.get(npc.getIndex());
        if (existSpawn != null && existSpawn.getNpc() == npc.getId()) {
            return;
        }
        NpcSpawn spawn = new NpcSpawn(npc.getId(), npc.getIndex());
        spawn.setOrientation(npc.getOrientation());
        spawn.getPoints().add(npc.getWorldLocation());
        this.spawns.put(npc.getIndex(), spawn);
        if (existSpawn != null) {
            log.debug("Replaced " + existSpawn.getNpc() + " with " + spawn.getNpc() + " due to same index but different ids.");
        } else {
            log.debug("Added new NPC to spawns: index=" + npc.getIndex() + ", id=" + npc.getId() + ", name=" + def.getName());
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updatedThisTick = 0;
        if (!this.enabled.isActive()) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            NpcSpawn spawn = this.spawns.get(npc.getIndex());
            if (spawn == null) continue;
            if (spawn.getOrientation() != -1 && npc.getOrientation() != spawn.getOrientation()) {
                spawn.setOrientation(-1);
            }
            if (!spawn.getPoints().add(npc.getWorldLocation())) continue;
            ++this.updatedThisTick;
        }
    }

    public NpcSpawnsButton getEnabled() {
        return this.enabled;
    }

    public JButton getSaveSpawns() {
        return this.saveSpawns;
    }

    public JButton getLoadSpawns() {
        return this.loadSpawns;
    }

    public JButton getClearSpawns() {
        return this.clearSpawns;
    }

    Map<Integer, NpcSpawn> getSpawns() {
        return this.spawns;
    }

    int getUpdatedThisTick() {
        return this.updatedThisTick;
    }
}

