/*
 * Decompiled with CFR 0.152.
 */
package com.lootbroadcastparty;

import com.google.inject.Provides;
import com.lootbroadcastparty.LootBroadcastPartyConfig;
import java.awt.Color;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMemberMessage;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.party.messages.UserSync;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Loot Broadcast Party", configName="LootBroadcastPartyConfig", description="Allows you to see and broadcast drops, level ups, and achievements from your party members", enabledByDefault=true)
public class LootBroadcastPartyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootBroadcastPartyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PartyService party;
    @Inject
    private WSClient wsClient;
    @Inject
    private LootBroadcastPartyConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;
    private Instant lastLogout;
    private NavigationButton navButton;
    private static final Pattern COLLECTION_LOG_PATTERN = Pattern.compile("^New item added to your collection log: (.+)$");
    private static final Pattern LEVEL_ADVANCE_PATTERN = Pattern.compile("^Congratulations, you've just advanced your (.+) level. You are now level (\\d+).$");
    private static final Pattern VALUABLE_DROP_PATTERN = Pattern.compile("<col=\\w+>Valuable drop: (.+?)<\\/col>");
    private static final Pattern COMBAT_ACHIEVEMENT_PATTERN = Pattern.compile("Congratulations, you've completed (a|an) (\\w+) combat task: (.+)");

    @Subscribe
    private void onChatMessage(ChatMessage chatMessage) {
        String broadcastMessage;
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = chatMessage.getMessage();
        Matcher clogMatcher = COLLECTION_LOG_PATTERN.matcher(message);
        Matcher levelAdvanceMatcher = LEVEL_ADVANCE_PATTERN.matcher(message);
        Matcher valuableDropMatcher = VALUABLE_DROP_PATTERN.matcher(message);
        Matcher achievementMatcher = COMBAT_ACHIEVEMENT_PATTERN.matcher(message);
        if (clogMatcher.matches()) {
            String itemName = clogMatcher.group(1);
            String nameAndText = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(Color.MAGENTA, this.client.getLocalPlayer().getName()).append(ChatColorType.HIGHLIGHT).append(" obtained a new collection log item: ").build();
            this.party.send((PartyMessage)new CustomAlert(MessageType.COLLECTION_LOG, nameAndText + itemName));
        }
        if (levelAdvanceMatcher.matches()) {
            broadcastMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(Color.MAGENTA, this.client.getLocalPlayer().getName()).append(ChatColorType.HIGHLIGHT).append(" has just reached level ").append(levelAdvanceMatcher.group(2) + " ").append(levelAdvanceMatcher.group(1) + ".").build();
            this.party.send((PartyMessage)new CustomAlert(MessageType.LEVEL_UP, broadcastMessage));
        }
        if (valuableDropMatcher.matches()) {
            broadcastMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(Color.MAGENTA, this.client.getLocalPlayer().getName()).append(ChatColorType.HIGHLIGHT).append(" just received a valuable drop: ").append(Color.RED, valuableDropMatcher.group(1)).build();
            this.party.send((PartyMessage)new CustomAlert(MessageType.VALUABLE_DROP, broadcastMessage));
        }
        if (achievementMatcher.matches()) {
            broadcastMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(Color.MAGENTA, this.client.getLocalPlayer().getName()).append(ChatColorType.HIGHLIGHT).append(" just completed the ").append(achievementMatcher.group(2) + " combat task: ").append(Color.GREEN, achievementMatcher.group(3).replaceAll("<col=[0-9a-fA-F]+>", "")).build();
            this.party.send((PartyMessage)new CustomAlert(MessageType.COMBAT_ACHIEVEMENT, broadcastMessage));
        }
    }

    @Subscribe
    public void onCustomAlert(CustomAlert alert) {
        if (this.isAllowed(alert.messageType)) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHAT).sender("Party").runeLiteFormattedMessage(alert.message).build());
        }
    }

    private boolean isAllowed(MessageType messageType) {
        if (messageType == MessageType.LEVEL_UP && this.config.levelUps()) {
            return true;
        }
        if (messageType == MessageType.COLLECTION_LOG && this.config.collectionLogs()) {
            return true;
        }
        if (messageType == MessageType.COMBAT_ACHIEVEMENT && this.config.combatAchievements()) {
            return true;
        }
        return messageType == MessageType.VALUABLE_DROP && this.config.valuableDrops();
    }

    protected void startUp() throws Exception {
        this.lastLogout = Instant.now();
        this.clientToolbar.addNavigation(this.navButton);
        this.wsClient.registerMessage(CustomAlert.class);
        SwingUtilities.invokeLater(this::requestSync);
    }

    protected void shutDown() throws Exception {
        this.lastLogout = null;
        this.clientToolbar.removeNavigation(this.navButton);
        this.wsClient.unregisterMessage(CustomAlert.class);
    }

    @Provides
    public LootBroadcastPartyConfig provideConfig(ConfigManager configManager) {
        return (LootBroadcastPartyConfig)configManager.getConfig(LootBroadcastPartyConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
    }

    void requestSync() {
        if (this.party.isInParty()) {
            UserSync userSync = new UserSync();
            this.party.send((PartyMessage)userSync);
        }
    }

    static enum MessageType {
        COLLECTION_LOG,
        LEVEL_UP,
        COMBAT_ACHIEVEMENT,
        VALUABLE_DROP;

    }

    public class CustomAlert
    extends PartyMemberMessage {
        MessageType messageType;
        String message;

        public CustomAlert(MessageType messageType, String message) {
            this.messageType = messageType;
            this.message = message;
        }
    }
}

