/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.cratelimit;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import io.hydrox.cratelimit.CrateLimiterConfig;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Crate Limiter", description="Slows down the opening of crates and jars", tags={"crate", "jar", "eclectic", "medium", "mediums", "rangers", "ranger", "clue", "clues", "open", "loot"})
public class CrateLimiterPlugin
extends Plugin {
    private static final Set<Integer> OPEN_EXCEPTIONS = ImmutableSet.of((Object)11941, (Object)13226, (Object)13639, (Object)9433, (Object)764, (Object)766, (Object[])new Integer[]{11159, 12791, 24416, 21389, 21387});
    private static final Set<Integer> BIRD_NESTS = ImmutableSet.of((Object)5070, (Object)5071, (Object)5072, (Object)5073, (Object)5074, (Object)7413, (Object[])new Integer[]{13653, 22798, 22800});
    @Inject
    private Client client;
    @Inject
    private CrateLimiterConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private int tick = -1;

    @Provides
    CrateLimiterConfig getConfig(ConfigManager configManager) {
        return (CrateLimiterConfig)configManager.getConfig(CrateLimiterConfig.class);
    }

    @Subscribe
    void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.CC_OP) {
            return;
        }
        if (event.getMenuOption().equals("Take")) {
            if (event.getId() != 22993) {
                return;
            }
        } else if (event.getMenuOption().equals("Search")) {
            if (!BIRD_NESTS.contains(event.getId())) {
                return;
            }
        } else if (event.getMenuOption().equals("Open")) {
            if (OPEN_EXCEPTIONS.contains(event.getId())) {
                return;
            }
            ItemComposition comp = this.client.getItemDefinition(event.getId());
            if (comp.getName().endsWith(" pack")) {
                return;
            }
            if (comp.getName().equals("Coin pouch")) {
                return;
            }
        } else if (!event.getMenuOption().equals("Loot")) {
            return;
        }
        if (this.client.getTickCount() - this.tick >= this.config.ticksPerItem()) {
            this.tick = this.client.getTickCount();
        } else {
            event.consume();
            if (this.config.showMessage()) {
                this.chatMessageManager.queue(QueuedMessage.builder().value("Woah there buddy, slow down!").type(ChatMessageType.ENGINE).build());
            }
        }
    }
}

