/*
 * Decompiled with CFR 0.152.
 */
package com.settimer;

import com.google.inject.Provides;
import com.settimer.SetTimer;
import com.settimer.SetTimerConfig;
import com.settimer.SetTimerPanel;
import com.settimer.SetTimerState;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Set Timer", description="Panel to show TzKal-Zuk timer", tags={"timer", "inferno", "pvm"})
public class SetTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SetTimerPlugin.class);
    private SetTimer setTimer;
    private SetTimerPanel panel;
    private NavigationButton navButton;
    private static boolean inInferno = false;
    private static final int INFERNO_REGION_ID = 9043;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private SetTimerConfig config;
    private final HotkeyListener setTimerKeyListener = new HotkeyListener(() -> this.config.timerHotkey()){

        public void keyPressed(KeyEvent e) {
            if (SetTimerPlugin.this.config.timerHotkey().matches(e)) {
                SetTimerPlugin.this.next();
            }
        }
    };

    @Provides
    SetTimerConfig getConfig(ConfigManager configManager) {
        return (SetTimerConfig)configManager.getConfig(SetTimerConfig.class);
    }

    protected void startUp() {
        this.setTimer = new SetTimer((BufferedImage)this.itemManager.getImage(22319), this);
        this.panel = (SetTimerPanel)((Object)this.injector.getInstance(SetTimerPanel.class));
        this.navButton = NavigationButton.builder().tooltip("Set Timer").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/tzkal-zuk.png")).priority(6).panel((PluginPanel)this.panel).build();
        if (this.isInInferno() || !this.config.hide()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
        this.keyManager.registerKeyListener((KeyListener)this.setTimerKeyListener);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this.setTimerKeyListener);
        this.clientToolbar.removeNavigation(this.navButton);
        this.infoBoxManager.removeIf(SetTimer.class::isInstance);
        this.panel.reset();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("settimer")) {
            return;
        }
        if (event.getKey().equals("hide")) {
            if (!inInferno && this.config.hide()) {
                this.clientToolbar.removeNavigation(this.navButton);
            } else {
                this.clientToolbar.addNavigation(this.navButton);
            }
        }
        if (event.getKey().equals("infobox")) {
            this.infoBoxManager.removeIf(SetTimer.class::isInstance);
            if (this.config.infobox() && this.setTimer.getState() != SetTimerState.IDLE) {
                this.infoBoxManager.addInfoBox((InfoBox)this.setTimer);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        inInferno = this.isInInferno();
        if (!inInferno && this.config.hide()) {
            this.clientToolbar.removeNavigation(this.navButton);
        } else {
            this.clientToolbar.addNavigation(this.navButton);
        }
    }

    public void next() {
        switch (this.setTimer.getState()) {
            case IDLE: {
                this.setTimer.start();
                this.setTimer.setState(SetTimerState.STARTED);
                this.panel.setButtonText("Pause");
                if (!this.config.infobox()) break;
                this.infoBoxManager.addInfoBox((InfoBox)this.setTimer);
                break;
            }
            case STARTED: {
                this.setTimer.stop();
                this.setTimer.setState(SetTimerState.PAUSED);
                this.panel.setButtonText("Resume");
                break;
            }
            case PAUSED: {
                this.setTimer.start();
                this.setTimer.setState(SetTimerState.RESUMED);
                this.panel.setButtonText("Reset");
                break;
            }
            case RESUMED: {
                this.setTimer.stop();
                this.setTimer.setState(SetTimerState.IDLE);
                this.panel.setButtonText("Start");
                this.infoBoxManager.removeIf(SetTimer.class::isInstance);
                break;
            }
        }
        this.update();
    }

    public void update() {
        this.panel.setTimerText(this.setTimer.getText());
    }

    private boolean isInInferno() {
        return this.client.getMapRegions() != null && ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9043);
    }
}

