/*
 * Decompiled with CFR 0.152.
 */
package com.settimer;

import com.settimer.SetTimerConfig;
import com.settimer.SetTimerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SetTimerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(SetTimerPanel.class);
    private final SetTimerPlugin plugin;
    private final SetTimerConfig config;
    private static JLabel timerLabel;
    private static JButton button;

    @Inject
    public SetTimerPanel(SetTimerPlugin plugin, SetTimerConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setLayout(new BorderLayout(0, 4));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel mainContent = new JPanel(new BorderLayout());
        button = new JButton("Start");
        button.setFont(new Font("SansSerif", 0, 30));
        button.setForeground(Color.WHITE);
        button.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorScheme.DARK_GRAY_COLOR), new EmptyBorder(20, 4, 20, 4)));
        timerLabel = new JLabel("3:30", 0);
        timerLabel.setFont(new Font("SansSerif", 1, 50));
        button.addActionListener(e -> this.plugin.next());
        mainContent.add((Component)timerLabel, "North");
        mainContent.add((Component)button, "South");
        this.add(mainContent, "Center");
    }

    public void setButtonText(String text) {
        button.setText(text);
    }

    public void setTimerText(String text) {
        timerLabel.setText(text);
    }

    public void reset() {
        this.setTimerText("3:30");
        this.setButtonText("Start");
    }
}

