/*
 * Decompiled with CFR 0.152.
 */
package com.settimer;

import com.settimer.SetTimerPlugin;
import com.settimer.SetTimerState;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;

public class SetTimer
extends InfoBox {
    private static Timer timer;
    private SetTimerState state;
    private int currentTime = 210;
    private static final int setTime = 210;
    private static final int jadTime = 105;
    final SetTimerPlugin plugin;

    public SetTimer(BufferedImage image, SetTimerPlugin plugin) {
        super(image, (Plugin)plugin);
        this.plugin = plugin;
        this.state = SetTimerState.IDLE;
    }

    public void start() {
        timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (SetTimer.this.currentTime-- == 0) {
                    SetTimer.this.currentTime = 210;
                }
                SetTimer.this.plugin.update();
            }
        }, 0L, 1000L);
    }

    public void stop() {
        timer.cancel();
        switch (this.state) {
            case STARTED: {
                this.currentTime += 105;
                break;
            }
            case IDLE: 
            case RESUMED: {
                this.currentTime = 210;
                break;
            }
        }
    }

    public String getText() {
        int minutes = this.currentTime / 60;
        int seconds = this.currentTime % 60;
        return String.format("%01d:%02d", minutes, seconds);
    }

    public Color getTextColor() {
        if (this.currentTime < 10) {
            return Color.RED.brighter();
        }
        return Color.WHITE;
    }

    public SetTimerPlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return "SetTimer(state=" + this.getState() + ", currentTime=" + this.getCurrentTime() + ", plugin=" + this.getPlugin() + ")";
    }

    SetTimerState getState() {
        return this.state;
    }

    void setState(SetTimerState state) {
        this.state = state;
    }

    int getCurrentTime() {
        return this.currentTime;
    }
}

