/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeaths;

import com.google.inject.Provides;
import com.zerodeaths.ZeroDeathsConfig;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ZeroDeaths")
public class ZeroDeathsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ZeroDeathsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    private String username;
    private Boolean firstRun = true;
    private Boolean playerIsDead = false;
    private Boolean scoring = false;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    @Inject
    private OkHttpClient okHttpClient;

    protected void startUp() throws Exception {
        this.configManager.setConfiguration("player", "registered", "false");
    }

    protected void shutDown() throws Exception {
        this.callApi("died");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && this.firstRun.booleanValue()) {
            this.executorService.scheduleAtFixedRate(this::checkForDeath, 10L, 1L, TimeUnit.SECONDS);
            this.executorService.schedule(this::checkAndPerformAction, 10L, TimeUnit.SECONDS);
            this.firstRun = false;
            this.scoring = true;
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.firstRun = true;
            if (this.scoring.booleanValue()) {
                this.callApi("score");
                this.scoring = false;
            }
        }
    }

    private void checkAndPerformAction() {
        String registered = this.configManager.getConfiguration("player", "registered");
        if (registered.equals("false")) {
            this.callApi("add");
        }
    }

    private void checkForDeath() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            int currentHP = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
            if (currentHP <= 0) {
                if (!this.playerIsDead.booleanValue()) {
                    this.playerIsDead = true;
                    this.callApi("died");
                }
            } else {
                this.playerIsDead = false;
            }
        }
    }

    private void callApi(String parameter) {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != null) {
            this.username = URLEncoder.encode(Objects.requireNonNull(localPlayer.getName()), StandardCharsets.UTF_8);
        }
        String apiURL = null;
        switch (parameter) {
            case "died": {
                apiURL = "https://nydiwq3xz0.execute-api.eu-west-1.amazonaws.com/dev/addUserDetails?username=" + this.username + "&died=true";
                break;
            }
            case "score": {
                apiURL = "https://nydiwq3xz0.execute-api.eu-west-1.amazonaws.com/dev/compareAndScore?username=" + this.username;
                break;
            }
            case "add": {
                apiURL = "https://nydiwq3xz0.execute-api.eu-west-1.amazonaws.com/dev/addUserDetails?username=" + this.username;
                this.configManager.setConfiguration("player", "registered", "true");
            }
        }
        assert (apiURL != null);
        FormBody requestBody = new FormBody.Builder().add("param1", "value1").add("param2", "value2").build();
        Request request = new Request.Builder().url(apiURL).post(RequestBody.create(null, (byte[])new byte[0])).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@Nullable Call call, @Nullable IOException e) {
            }

            public void onResponse(@Nullable Call call, @Nullable Response response) throws IOException {
            }
        });
    }

    @Provides
    ZeroDeathsConfig provideConfig(ConfigManager configManager) {
        return (ZeroDeathsConfig)configManager.getConfig(ZeroDeathsConfig.class);
    }
}

