/*
 * Decompiled with CFR 0.152.
 */
package xyz.evaan;

import com.google.inject.Inject;
import com.google.inject.Provides;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.evaan.InfernoTrackerConfig;
import xyz.evaan.ui.InfernoTrackerPanel;

@PluginDescriptor(name="Inferno Tracker", description="A plugin to help track your inferno attempts.")
public class InfernoTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InfernoTrackerPlugin.class);
    private InfernoTrackerPanel panel;
    private NavigationButton navButton;
    private static final Pattern wavePattern = Pattern.compile(".*Wave: (\\d+).*");
    private static int wave = 0;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    public InfernoTrackerConfig config;
    File configFile = RuneLite.RUNELITE_DIR.toPath().resolve("InfernoTracker.txt").toFile();

    protected void startUp() throws Exception {
        this.panel = new InfernoTrackerPanel(this);
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (Exception exception) {}
        } else {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.configFile)));
            while ((line = br.readLine()) != null) {
                this.panel.addAttempt(Integer.valueOf(line));
            }
        }
        this.panel.update();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (InfernoTrackerPlugin.this.configFile.exists()) {
                        InfernoTrackerPlugin.this.configFile.delete();
                    }
                    InfernoTrackerPlugin.this.configFile.createNewFile();
                    if (InfernoTrackerPlugin.this.panel.attempts.isEmpty()) {
                        return;
                    }
                    FileWriter writer = new FileWriter(InfernoTrackerPlugin.this.configFile);
                    for (int wave : InfernoTrackerPlugin.this.panel.attempts) {
                        writer.write(wave + System.lineSeparator());
                    }
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.navButton = NavigationButton.builder().tooltip("Inferno Tracker").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png")).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        log.info("Inferno Tracker started!");
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (!ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9043)) {
            wave = 0;
            return;
        }
        Matcher waveMatcher = wavePattern.matcher(event.getMessage());
        if (!waveMatcher.matches()) {
            return;
        }
        wave = Integer.parseInt(waveMatcher.group(1));
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        if (ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9043) && event.getActor() == this.client.getLocalPlayer()) {
            this.panel.addAttempt(wave);
        }
    }

    @Provides
    InfernoTrackerConfig provideConfig(ConfigManager configManager) {
        return (InfernoTrackerConfig)configManager.getConfig(InfernoTrackerConfig.class);
    }

    public InfernoTrackerConfig getConfig() {
        return this.config;
    }
}

