/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.storage.panel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import tictac7x.storage.StorageConfig;
import tictac7x.storage.panel.DataItem;
import tictac7x.storage.panel.PanelItems;
import tictac7x.storage.panel.Search;

public class StoragePanel
extends PluginPanel {
    private final ClientThread client_thread;
    private final ItemManager items;
    private final StorageConfig config;
    private final JsonParser parser = new JsonParser();
    private List<DataItem> list_items;
    private String search = "";
    private Search input_search;
    private JScrollPane panel_scoller;
    private PanelItems panel_items;

    public StoragePanel(ClientThread client_thread, ItemManager items, StorageConfig config) {
        super(false);
        this.client_thread = client_thread;
        this.items = items;
        this.config = config;
        this.loadItemsFromConfig();
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.input_search = new Search(this::searchItems);
        this.add((Component)this.input_search.get(), "North");
        this.panel_items = new PanelItems(client_thread, items, this.list_items);
        this.panel_scoller = new JScrollPane(this.panel_items.get());
        this.add(this.panel_scoller, "Center");
    }

    private void loadItemsFromConfig() {
        this.list_items = new ArrayList<DataItem>();
        JsonObject bank = (JsonObject)this.parser.parse(this.config.getBank());
        for (Map.Entry item : bank.entrySet()) {
            this.list_items.add(new DataItem(Integer.parseInt((String)item.getKey()), ((JsonElement)item.getValue()).getAsInt()));
        }
    }

    public void searchItems(String search) {
        this.search = search;
        if (search.length() == 0) {
            this.panel_items.update(this.list_items);
            return;
        }
        String searchLowercase = search.toLowerCase();
        this.client_thread.invoke(() -> {
            ArrayList<DataItem> list_items_starts_with = new ArrayList<DataItem>();
            ArrayList<DataItem> list_items_contains = new ArrayList<DataItem>();
            for (DataItem item : this.list_items) {
                String name = this.items.getItemComposition(item.id).getName().toLowerCase();
                if (name.startsWith(searchLowercase)) {
                    list_items_starts_with.add(item);
                    continue;
                }
                if (!name.contains(searchLowercase)) continue;
                list_items_contains.add(item);
            }
            list_items_starts_with.addAll(list_items_contains);
            this.panel_items.update(list_items_starts_with);
        });
    }

    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("tictac7x-storage") || !event.getKey().equals("bank")) {
            return;
        }
        this.loadItemsFromConfig();
        this.searchItems(this.search);
    }
}

