/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.storage.panel;

import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import tictac7x.storage.panel.DataItem;
import tictac7x.storage.panel.PanelItem;

public class PanelItems {
    private final ClientThread client_thread;
    private final ItemManager items;
    private JPanel panel;

    public PanelItems(ClientThread client_thread, ItemManager items, List<DataItem> list_items) {
        this.client_thread = client_thread;
        this.items = items;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addItemsToPanel(list_items);
    }

    public Component get() {
        return this.panel;
    }

    public void update(List<DataItem> list_items) {
        this.panel.removeAll();
        SwingUtilities.invokeLater(() -> this.addItemsToPanel(list_items));
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void addItemsToPanel(List<DataItem> list_items) {
        for (DataItem item : list_items) {
            PanelItem panel_item = new PanelItem(item.id, item.quantity, this.client_thread, this.items);
            this.panel.add(panel_item.get());
        }
    }
}

