/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.storage;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.storage.Storage;
import tictac7x.storage.StorageConfig;
import tictac7x.storage.StorageInventory;
import tictac7x.storage.panel.StoragePanel;

@PluginDescriptor(name="Storage", description="Show overlays of inventory and bank", tags={"storage", "bank", "inventory", "item"})
public class TicTac7xStoragePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TicTac7xStoragePlugin.class);
    private String plugin_version = "v0.5.1";
    private String plugin_message = "<colHIGHLIGHT>Storage " + this.plugin_version + ":<br><colHIGHLIGHT>* Overlays without any items no longer rendering";
    @Inject
    private Client client;
    @Inject
    private ClientToolbar client_toolbar;
    @Inject
    private StorageConfig config;
    @Inject
    private ClientThread client_thread;
    @Inject
    private ConfigManager configs;
    @Inject
    private ItemManager items;
    @Inject
    private OverlayManager overlays;
    @Inject
    private ChatMessageManager chat_messages;
    private Storage[] storages;
    private StoragePanel storage_panel;
    @Nullable
    private NavigationButton navigation_button;

    @Provides
    StorageConfig provideConfig(ConfigManager configManager) {
        return (StorageConfig)configManager.getConfig(StorageConfig.class);
    }

    protected void startUp() {
        for (Storage storage : this.storages = new Storage[]{new StorageInventory("inventory", InventoryID.INVENTORY, WidgetInfo.INVENTORY, this.client, this.client_thread, this.configs, this.config, this.items), new Storage("bank", InventoryID.BANK, WidgetInfo.BANK_CONTAINER, this.client, this.client_thread, this.configs, this.config, this.items)}) {
            this.overlays.add((Overlay)storage);
        }
        this.storage_panel = new StoragePanel(this.client_thread, this.items, this.config);
        this.updateNavigationButton();
    }

    protected void shutDown() {
        for (Storage storage : this.storages) {
            this.overlays.remove((Overlay)storage);
        }
        if (this.config.showPanel()) {
            this.client_toolbar.removeNavigation(this.navigation_button);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        for (Storage storage : this.storages) {
            storage.onItemContainerChanged(event);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("tictac7x-storage")) {
            return;
        }
        if (event.getKey().equals("panel") || event.getKey().equals("panel_priority")) {
            this.updateNavigationButton();
            return;
        }
        this.storage_panel.onConfigChanged(event);
        for (Storage storage : this.storages) {
            storage.onConfigChanged(event);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN && !this.config.getVersion().equals(this.plugin_version)) {
            this.configs.setConfiguration("tictac7x-storage", "version", this.plugin_version);
            this.chat_messages.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(this.plugin_message).build());
        }
    }

    private void updateNavigationButton() {
        if (this.navigation_button != null) {
            this.client_toolbar.removeNavigation(this.navigation_button);
        }
        if (this.config.showPanel()) {
            this.client_thread.invokeLater(() -> {
                this.navigation_button = NavigationButton.builder().tooltip("Storage").icon((BufferedImage)this.items.getImage(6759)).priority(this.config.getPanelPriority()).panel((PluginPanel)this.storage_panel).build();
                this.client_toolbar.addNavigation(this.navigation_button);
            });
        }
    }
}

