/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.storage;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.util.ImageUtil;
import tictac7x.storage.Storage;
import tictac7x.storage.StorageConfig;

public class StorageInventory
extends Storage {
    private int INVENTORY_SIZE = 28;
    private int NULL_ITEM = -1;
    private int panel_width = 0;
    private int empty = 0;
    private final BufferedImage inventory_png = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"inventory.png");
    private ImageComponent inventory_image;
    @Nullable
    private ImageComponent inventory_free;

    public StorageInventory(String storage_id, InventoryID item_container_id, WidgetInfo widget_info, Client client, ClientThread client_thread, ConfigManager configs, StorageConfig config, ItemManager items) {
        super(storage_id, item_container_id, widget_info, client, client_thread, configs, config, items);
        client_thread.invokeLater(() -> this.updateInventoryItem(this.INVENTORY_SIZE));
        client_thread.invokeLater(() -> this.updateInventoryFree(this.INVENTORY_SIZE));
    }

    @Override
    public void onItemContainerChanged(ItemContainerChanged event) {
        super.onItemContainerChanged(event);
        this.updateEmpty(event);
    }

    @Override
    protected void renderBefore() {
        switch (this.config.getInventoryEmpty()) {
            case TOP: {
                this.renderFree();
                return;
            }
            case FIRST: {
                this.itemsPanelComponent.getChildren().add(this.inventory_image);
                return;
            }
        }
    }

    @Override
    protected void renderAfter() {
        switch (this.config.getInventoryEmpty()) {
            case LAST: {
                this.itemsPanelComponent.getChildren().add(this.inventory_image);
                return;
            }
            case BOTTOM: {
                this.renderFree();
                return;
            }
        }
    }

    private void renderFree() {
        if (this.inventory_free == null || this.inventory_free.getBounds().width == 0 || this.itemsPanelComponent.getBounds().width != this.panel_width) {
            this.updateInventoryFree(this.empty);
            this.panel_width = this.itemsPanelComponent.getBounds().width;
        }
        if (this.inventory_free != null) {
            this.panelComponent.getChildren().add(this.inventory_free);
        }
    }

    private void updateEmpty(ItemContainerChanged event) {
        if (event.getContainerId() != this.item_container_id) {
            return;
        }
        int empty = this.INVENTORY_SIZE;
        for (Item item : event.getItemContainer().getItems()) {
            if (item.getId() == this.NULL_ITEM) continue;
            --empty;
        }
        this.empty = empty;
        this.updateInventoryItem(empty);
        this.updateInventoryFree(empty);
    }

    private void updateInventoryItem(int empty) {
        String free = String.valueOf(empty);
        BufferedImage inventory_image = new BufferedImage(this.inventory_png.getWidth(), this.inventory_png.getHeight(), this.inventory_png.getType());
        Graphics graphics = inventory_image.getGraphics();
        graphics.drawImage(this.inventory_png, 0, 0, null);
        FontMetrics fm = graphics.getFontMetrics();
        graphics.setFont(FontManager.getRunescapeSmallFont());
        graphics.setColor(Color.BLACK);
        graphics.drawString(free, 1, fm.getAscent());
        graphics.setColor(Color.YELLOW);
        graphics.drawString(free, 0, fm.getAscent() - 1);
        graphics.dispose();
        this.inventory_image = new ImageComponent(inventory_image);
    }

    private void updateInventoryFree(int empty) {
        try {
            String free = empty + " free";
            BufferedImage free_image = new BufferedImage(this.itemsPanelComponent.getBounds().width - 8, 16, 6);
            Graphics graphics = free_image.getGraphics();
            FontMetrics font_metrics = graphics.getFontMetrics();
            graphics.setFont(FontManager.getRunescapeFont());
            graphics.setColor(Color.BLACK);
            graphics.drawString(free, (free_image.getWidth() - font_metrics.stringWidth(free)) / 2 + 1, font_metrics.getAscent() + 2);
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawString(free, (free_image.getWidth() - font_metrics.stringWidth(free)) / 2, font_metrics.getAscent() + 1);
            graphics.dispose();
            this.inventory_free = new ImageComponent(free_image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

