/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import tictac7x.storage.StorageConfig;

public class Storage
extends OverlayPanel {
    private final String storage_id;
    protected final int item_container_id;
    private final WidgetInfo widget_info;
    private final Client client;
    private final ClientThread client_thread;
    private final ConfigManager configs;
    protected final StorageConfig config;
    private final ItemManager items;
    private final int PLACEHOLDER_TEMPLATE_ID = 14401;
    protected final PanelComponent itemsPanelComponent = new PanelComponent();
    private final List<ImageComponent> images = new ArrayList<ImageComponent>();
    private final JsonParser parser = new JsonParser();

    public Storage(String storage_id, InventoryID item_container_id, WidgetInfo widget_info, Client client, ClientThread client_thread, ConfigManager configs, StorageConfig config, ItemManager items) {
        this.storage_id = storage_id;
        this.item_container_id = item_container_id.getId();
        this.widget_info = widget_info;
        this.client = client;
        this.client_thread = client_thread;
        this.configs = configs;
        this.config = config;
        this.items = items;
        this.setPreferredPosition(OverlayPosition.BOTTOM_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.panelComponent.setGap(new Point(0, 10));
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        this.panelComponent.setBorder(new Rectangle(10, 10, 6, 10));
        this.itemsPanelComponent.setWrap(true);
        this.itemsPanelComponent.setBackgroundColor(null);
        this.itemsPanelComponent.setGap(new Point(6, 4));
        this.itemsPanelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.itemsPanelComponent.setBorder(new Rectangle(0, 0, 0, 0));
        this.client_thread.invokeLater(() -> this.updateImages(configs.getConfiguration("tictac7x-storage", storage_id)));
    }

    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != this.item_container_id) {
            return;
        }
        ItemContainer item_container = event.getItemContainer();
        JsonObject json = new JsonObject();
        for (Item item : item_container.getItems()) {
            String id;
            if (item.getId() == -1 || item.getQuantity() == 0 || this.items.getItemComposition(item.getId()).getPlaceholderTemplateId() == 14401 || json.has(id = String.valueOf(item.getId()))) continue;
            json.addProperty(id, (Number)item_container.count(item.getId()));
        }
        this.configs.setConfiguration("tictac7x-storage", this.storage_id, json.toString());
    }

    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("tictac7x-storage") | !event.getKey().equals(this.storage_id) && !event.getKey().equals(this.storage_id + "_visible") && !event.getKey().equals(this.storage_id + "_hidden")) {
            return;
        }
        this.client_thread.invokeLater(() -> this.updateImages(this.configs.getConfiguration("tictac7x-storage", this.storage_id)));
    }

    private void updateImages(String items) {
        ArrayList<ImageComponent> images = new ArrayList<ImageComponent>();
        JsonObject json = this.parser.parse(items).getAsJsonObject();
        for (Map.Entry entry : json.entrySet()) {
            int item_id = Integer.parseInt((String)entry.getKey());
            int item_quantity = ((JsonElement)entry.getValue()).getAsInt();
            if (!this.isVisible(item_id) || this.isHidden(item_id)) continue;
            images.add(new ImageComponent((BufferedImage)this.items.getImage(item_id, item_quantity, true)));
        }
        this.images.clear();
        this.images.addAll(images);
    }

    private String[] getVisibleItems() {
        String[] visible = new String[]{};
        try {
            visible = this.configs.getConfiguration("tictac7x-storage", this.storage_id + "_visible").split(",");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return visible;
    }

    private String[] getHiddenItems() {
        String[] hidden = new String[]{};
        try {
            hidden = this.configs.getConfiguration("tictac7x-storage", this.storage_id + "_hidden").split(",");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hidden;
    }

    private boolean isVisible(int item_id) {
        String[] visible = this.getVisibleItems();
        ItemComposition item = this.items.getItemComposition(item_id);
        if (visible.length == 0 || visible.length == 1 && visible[0].equals("")) {
            return true;
        }
        for (String name : visible) {
            if (!item.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isHidden(int item_id) {
        String[] hidden = this.getHiddenItems();
        ItemComposition item = this.items.getItemComposition(item_id);
        if (hidden.length == 0 || hidden.length == 1 && hidden[0].equals("")) {
            return false;
        }
        for (String name : hidden) {
            if (!item.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    private boolean show() {
        return Boolean.parseBoolean(this.configs.getConfiguration("tictac7x-storage", this.storage_id + "_show"));
    }

    private boolean autoHide() {
        return Boolean.parseBoolean(this.configs.getConfiguration("tictac7x-storage", this.storage_id + "_auto_hide"));
    }

    private boolean isWidgetVisible() {
        Widget widget = this.client.getWidget(this.widget_info);
        return widget != null && !widget.isHidden();
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.show()) {
            return null;
        }
        if (this.autoHide() && this.isWidgetVisible()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        this.itemsPanelComponent.getChildren().clear();
        this.renderBefore();
        this.images.forEach(image -> this.itemsPanelComponent.getChildren().add(image));
        this.panelComponent.getChildren().add(this.itemsPanelComponent);
        this.renderAfter();
        if (this.itemsPanelComponent.getChildren().size() == 0) {
            return null;
        }
        return super.render(graphics);
    }

    protected void renderBefore() {
    }

    protected void renderAfter() {
    }
}

