/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.PouchUsageLeft;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

class RCPouchOverlay
extends WidgetItemOverlay {
    private final PouchUsageLeft plugin;

    @Inject
    private RCPouchOverlay(PouchUsageLeft plugin) {
        this.showOnInventory();
        this.plugin = plugin;
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (!this.plugin.getItemUses().containsKey(itemId)) {
            return;
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y + bounds.height));
        int usesLeft = this.plugin.maxItemUses.get(itemId) - this.plugin.getItemUses().get(itemId);
        if (usesLeft > 12) {
            textComponent.setColor(Color.WHITE);
        } else {
            textComponent.setColor(Color.RED);
        }
        textComponent.setText(Integer.toString(usesLeft));
        textComponent.render(graphics);
    }
}

