/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.RCPouchOverlay;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Runecrafting counter")
public class PouchUsageLeft
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PouchUsageLeft.class);
    private static final int SPELL_CONTACT_ANIMATION_ID = 4413;
    private static final int[] AREAS_CLOSE_TO_ZMI = new int[]{9778, 12119};
    private static final int MED_POUCH = 5510;
    private static final int LARGE_POUCH = 5512;
    private static final int GIANT_POUCH = 5514;
    private static final int COLOSSAL_POUCH = 26784;
    private static final int MED_POUCH_USES = 264;
    private static final int LARGE_POUCH_USES = 279;
    private static final int GIANT_POUCH_USES = 120;
    private static final int COLOSSAL_POUCH_USES = 320;
    private Map<Integer, Integer> itemUses = new HashMap<Integer, Integer>(){
        {
            this.put(5510, 0);
            this.put(5512, 0);
            this.put(5514, 0);
            this.put(26784, 0);
        }
    };
    public final Map<Integer, Integer> maxItemUses = new HashMap<Integer, Integer>(){
        {
            this.put(5510, 264);
            this.put(5512, 279);
            this.put(5514, 120);
            this.put(26784, 320);
        }
    };
    private Multiset<Integer> previousInventorySnapshot;
    private int lastClickedItem = -1;
    private boolean isClose = false;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RCPouchOverlay rcOverlay;
    @Inject
    private ItemManager itemManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.rcOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.rcOverlay);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        String actorName;
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        String playerName = this.client.getLocalPlayer().getName();
        if (!playerName.equals(actorName = event.getActor().getName())) {
            return;
        }
        int animId = event.getActor().getAnimation();
        if (animId == 4413) {
            this.itemUses.replaceAll((k, v) -> 0);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.isClose = this.isCloseToZMI();
    }

    private boolean isCloseToZMI() {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return false;
        }
        WorldPoint location = local.getWorldLocation();
        for (int area : AREAS_CLOSE_TO_ZMI) {
            if (location.getRegionID() != area) continue;
            return true;
        }
        return false;
    }

    private Multiset<Integer> getInventorySnapshot() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        HashMultiset inventorySnapshot = HashMultiset.create();
        if (inventory != null) {
            Arrays.stream(inventory.getItems()).forEach(arg_0 -> PouchUsageLeft.lambda$getInventorySnapshot$1((Multiset)inventorySnapshot, arg_0));
        }
        return inventorySnapshot;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.previousInventorySnapshot == null) {
            return;
        }
        if (this.lastClickedItem == -1) {
            return;
        }
        Multiset<Integer> currentInventorySnapshot = this.getInventorySnapshot();
        Multiset itemsRemoved = Multisets.difference(this.previousInventorySnapshot, currentInventorySnapshot);
        if (itemsRemoved.isEmpty()) {
            log.info("Did not actually fill anything...");
            return;
        }
        int removedItemCount = (int)itemsRemoved.stream().filter(k -> k == 24704 || k == 7936 || k == 26879).count();
        log.info("Stored {} items", (Object)removedItemCount);
        this.itemUses.put(this.lastClickedItem, this.itemUses.get(this.lastClickedItem) + removedItemCount);
        this.lastClickedItem = -1;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String itemName;
        int itemId;
        this.lastClickedItem = -1;
        if (event.getMenuOption() == null || !event.getMenuOption().equals("Fill")) {
            return;
        }
        int inventoryIndex = event.getActionParam();
        if (event.getWidgetId() == WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getId()) {
            ItemContainer inventoryContainer = this.client.getItemContainer(InventoryID.INVENTORY);
            Item item = inventoryContainer.getItem(inventoryIndex);
            itemId = item.getId();
            itemName = item.toString();
        } else {
            ItemComposition itemComposition = this.itemManager.getItemComposition(event.getId());
            itemId = itemComposition.getId();
            itemName = itemComposition.getName();
        }
        if (!this.itemUses.containsKey(itemId)) {
            log.info("Filled an item that we don't know about: {} with ID: {}", (Object)itemName, (Object)itemId);
            return;
        }
        this.previousInventorySnapshot = this.getInventorySnapshot();
        this.lastClickedItem = itemId;
    }

    public Map<Integer, Integer> getItemUses() {
        return this.itemUses;
    }

    public boolean isClose() {
        return this.isClose;
    }

    private static /* synthetic */ void lambda$getInventorySnapshot$1(Multiset inventorySnapshot, Item item) {
        inventorySnapshot.add((Object)item.getId(), item.getQuantity());
    }
}

