/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data.modifiers.ui;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import net.runelite.client.ui.ColorScheme;

public class SelectableLabel
extends JLabel {
    private static final Color SELECTED_BACKGROUND = new Color(0, 70, 0);
    private static final Color SELECTED_HOVER_BACKGROUND = new Color(0, 100, 0);
    private static final Color BACKGROUND = ColorScheme.DARK_GRAY_COLOR;
    private static final Color BACKGROUND_HOVER = ColorScheme.DARK_GRAY_HOVER_COLOR;
    private boolean selected = false;
    private Runnable callback = null;

    public SelectableLabel() {
        this.setOpaque(true);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setBackground(BACKGROUND);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                SelectableLabel.this.setSelected(!SelectableLabel.this.selected);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SelectableLabel label = (SelectableLabel)e.getSource();
                if (SelectableLabel.this.selected) {
                    label.setBackground(SELECTED_HOVER_BACKGROUND);
                } else {
                    label.setBackground(BACKGROUND_HOVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SelectableLabel label = (SelectableLabel)e.getSource();
                if (SelectableLabel.this.selected) {
                    label.setBackground(SELECTED_BACKGROUND);
                } else {
                    label.setBackground(BACKGROUND);
                }
            }
        });
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, true);
    }

    public void setSelected(boolean selected, boolean runCallback) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.setBackground(selected ? SELECTED_BACKGROUND : BACKGROUND);
        if (runCallback && this.callback != null) {
            this.callback.run();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }
}

