/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data.modifiers.ui;

import java.util.function.BiConsumer;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.data.modifiers.Modifier;
import thestonedturtle.bankedexperience.data.modifiers.ModifierComponent;
import thestonedturtle.bankedexperience.data.modifiers.ui.LabeledCheckbox;

public class ModifierPanel
extends LabeledCheckbox
implements ModifierComponent {
    private static final Logger log = LoggerFactory.getLogger(ModifierPanel.class);
    private final Modifier modifier;
    private BiConsumer<Modifier, Boolean> modifierConsumer;

    public ModifierPanel(Modifier modifier) {
        super(modifier.getName());
        this.modifier = modifier;
        this.getButton().addItemListener(l -> {
            if (this.modifierConsumer == null) {
                log.warn("Toggling a modifier wth no consumer: {}", (Object)modifier);
                return;
            }
            this.modifierConsumer.accept(modifier, this.getButton().isSelected());
        });
    }

    @Override
    public Boolean isModifierEnabled() {
        return this.getButton().isSelected();
    }

    @Override
    public void setModifierEnabled(boolean enabled) {
        this.getButton().setSelected(enabled);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifierConsumer(BiConsumer<Modifier, Boolean> modifierConsumer) {
        this.modifierConsumer = modifierConsumer;
    }
}

