/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data.modifiers;

import com.google.common.primitives.Booleans;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.ItemComposition;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.DynamicGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.modifiers.ConsumptionModifier;
import thestonedturtle.bankedexperience.data.modifiers.Modifier;
import thestonedturtle.bankedexperience.data.modifiers.ModifierComponent;
import thestonedturtle.bankedexperience.data.modifiers.ui.SelectableLabel;

public class SkillingOutfit
extends ConsumptionModifier
implements ModifierComponent {
    private static final Logger log = LoggerFactory.getLogger(SkillingOutfit.class);
    private final float HELM_BONUS = 0.004f;
    private final float TOP_BONUS = 0.008f;
    private final float BOTTOM_BONUS = 0.006f;
    private final float BOOTS_BONUS = 0.002f;
    private final float SET_BONUS = 0.025f;
    private BiConsumer<Modifier, Boolean> modifierConsumer;
    private final Runnable callback = () -> {
        if (this.modifierConsumer == null) {
            log.warn("Toggling SkillingOutfit modifier wth no consumer: {}", (Object)this);
            return;
        }
        this.modifierConsumer.accept(this, this.isModifierEnabled());
    };
    final JPanel panel = new JPanel();
    final SelectableLabel helm;
    final SelectableLabel top;
    final SelectableLabel bottom;
    final SelectableLabel boots;

    SkillingOutfit(Skill skill, String name, Collection<Activity> included, Collection<Activity> ignored, ItemManager itemManager, ItemComposition ... items) {
        super(skill, name, 0.0f, included, ignored);
        assert (items.length == 4);
        ItemComposition helmComp = items[0];
        this.helm = new SelectableLabel();
        this.helm.setToolTipText("<html>" + helmComp.getName() + "<br/>Increases xp gained by 0.4%</html>");
        this.helm.setCallback(this.callback);
        ItemComposition topComp = items[1];
        this.top = new SelectableLabel();
        this.top.setToolTipText("<html>" + topComp.getName() + "<br/>Increases xp gained by 0.8%</html>");
        this.top.setCallback(this.callback);
        ItemComposition bottomComp = items[2];
        this.bottom = new SelectableLabel();
        this.bottom.setToolTipText("<html>" + bottomComp.getName() + "<br/>Increases xp gained by 0.6%</html>");
        this.bottom.setCallback(this.callback);
        ItemComposition bootComp = items[3];
        this.boots = new SelectableLabel();
        this.boots.setToolTipText("<html>" + bootComp.getName() + "<br/>Increases xp gained by 0.2%</html>");
        this.boots.setCallback(this.callback);
        JPanel container = new JPanel();
        container.setLayout((LayoutManager)new DynamicGridLayout(1, 0, 2, 0));
        container.add(this.helm);
        container.add(this.top);
        container.add(this.bottom);
        container.add(this.boots);
        this.panel.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 2));
        this.panel.setToolTipText("<html>Increases xp gained while worn.<br/>The full set increases the bonus by 0.5% for 2.5% instead of 2% bonus xp</html>");
        this.panel.add(new JLabel(name));
        this.panel.add(container);
        itemManager.getImage(items[0].getId()).addTo((JLabel)this.helm);
        itemManager.getImage(items[1].getId()).addTo((JLabel)this.top);
        itemManager.getImage(items[2].getId()).addTo((JLabel)this.bottom);
        itemManager.getImage(items[3].getId()).addTo((JLabel)this.boots);
    }

    int getEnabledButtonCount() {
        return Booleans.countTrue((boolean[])new boolean[]{this.helm.isSelected(), this.top.isSelected(), this.bottom.isSelected(), this.boots.isSelected()});
    }

    @Override
    public Modifier getModifier() {
        return this;
    }

    @Override
    public Boolean isModifierEnabled() {
        return this.getEnabledButtonCount() > 0;
    }

    @Override
    public void setModifierEnabled(boolean enabled) {
        this.helm.setSelected(enabled, false);
        this.top.setSelected(enabled, false);
        this.bottom.setSelected(enabled, false);
        this.boots.setSelected(enabled, false);
        this.callback.run();
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    protected double calculateBonusXPMultiplier() {
        float bonusXP = 1.0f;
        if (this.getEnabledButtonCount() == 4) {
            bonusXP += 0.025f;
        } else {
            bonusXP += this.helm.isSelected() ? 0.004f : 0.0f;
            bonusXP += this.top.isSelected() ? 0.008f : 0.0f;
            bonusXP += this.bottom.isSelected() ? 0.006f : 0.0f;
            bonusXP += this.boots.isSelected() ? 0.002f : 0.0f;
        }
        return bonusXP;
    }

    @Override
    public double appliedXpRate(Activity activity) {
        double bonusXP = this.calculateBonusXPMultiplier();
        return super.appliedXpRate(activity) * bonusXP;
    }

    @Override
    public ModifierComponent generateModifierComponent() {
        return this;
    }

    public void setTooltip(String tooltip) {
        this.panel.setToolTipText("<html>Increases xp gained while worn.<br/>The full set increases the bonus by 0.5% for 2.5% instead of 2% bonus xp<br/>" + tooltip + "</html>");
    }

    @Override
    public void setModifierConsumer(BiConsumer<Modifier, Boolean> modifierConsumer) {
        this.modifierConsumer = modifierConsumer;
    }
}

